package zio.aws.route53recoverycontrolconfig.model
import java.lang.Integer
import zio.aws.route53recoverycontrolconfig.model.primitives.{
  MaxResults,
  __string
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListRoutingControlsRequest(
    controlPanelArn: __string,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListRoutingControlsRequest = {
    import ListRoutingControlsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListRoutingControlsRequest
      .builder()
      .controlPanelArn(__string.unwrap(controlPanelArn): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.ListRoutingControlsRequest.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.ListRoutingControlsRequest
      .wrap(buildAwsValue())
}
object ListRoutingControlsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListRoutingControlsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.ListRoutingControlsRequest =
      zio.aws.route53recoverycontrolconfig.model.ListRoutingControlsRequest(
        controlPanelArn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def controlPanelArn: __string
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def getControlPanelArn: ZIO[Any, Nothing, __string] =
      ZIO.succeed(controlPanelArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListRoutingControlsRequest
  ) extends zio.aws.route53recoverycontrolconfig.model.ListRoutingControlsRequest.ReadOnly {
    override val controlPanelArn: __string =
      zio.aws.route53recoverycontrolconfig.model.primitives
        .__string(impl.controlPanelArn())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.primitives.MaxResults(value)
      )
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.primitives.__string(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListRoutingControlsRequest
  ): zio.aws.route53recoverycontrolconfig.model.ListRoutingControlsRequest.ReadOnly =
    new Wrapper(impl)
}
