package zio.aws.route53recoverycontrolconfig.model
import zio.aws.route53recoverycontrolconfig.model.primitives.__stringMin1Max8096PatternS
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListRoutingControlsResponse(
    nextToken: Optional[__stringMin1Max8096PatternS] = Optional.Absent,
    routingControls: Optional[
      Iterable[zio.aws.route53recoverycontrolconfig.model.RoutingControl]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListRoutingControlsResponse = {
    import ListRoutingControlsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListRoutingControlsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        routingControls.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routingControls)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.ListRoutingControlsResponse.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.ListRoutingControlsResponse
      .wrap(buildAwsValue())
}
object ListRoutingControlsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListRoutingControlsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.ListRoutingControlsResponse =
      zio.aws.route53recoverycontrolconfig.model.ListRoutingControlsResponse(
        nextToken.map(value => value),
        routingControls.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[__stringMin1Max8096PatternS]
    def routingControls: Optional[
      List[zio.aws.route53recoverycontrolconfig.model.RoutingControl.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, __stringMin1Max8096PatternS] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRoutingControls: ZIO[Any, AwsError, List[
      zio.aws.route53recoverycontrolconfig.model.RoutingControl.ReadOnly
    ]] = AwsError.unwrapOptionField("routingControls", routingControls)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListRoutingControlsResponse
  ) extends zio.aws.route53recoverycontrolconfig.model.ListRoutingControlsResponse.ReadOnly {
    override val nextToken: Optional[__stringMin1Max8096PatternS] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value => value: __stringMin1Max8096PatternS)
    override val routingControls: Optional[
      List[zio.aws.route53recoverycontrolconfig.model.RoutingControl.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.routingControls())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53recoverycontrolconfig.model.RoutingControl.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListRoutingControlsResponse
  ): zio.aws.route53recoverycontrolconfig.model.ListRoutingControlsResponse.ReadOnly =
    new Wrapper(impl)
}
