package zio.aws.route53recoverycontrolconfig.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.route53recoverycontrolconfig.model.primitives.{
  __string,
  MaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAssociatedRoute53HealthChecksRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent,
    routingControlArn: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest = {
    import ListAssociatedRoute53HealthChecksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .routingControlArn(routingControlArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest
      .wrap(buildAwsValue())
}
object ListAssociatedRoute53HealthChecksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest =
      zio.aws.route53recoverycontrolconfig.model
        .ListAssociatedRoute53HealthChecksRequest(
          maxResults.map(value => value),
          nextToken.map(value => value),
          routingControlArn
        )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[__string]
    def routingControlArn: __string
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRoutingControlArn: ZIO[Any, Nothing, __string] =
      ZIO.succeed(routingControlArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest
  ) extends zio.aws.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.primitives.MaxResults(value)
      )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val routingControlArn: __string =
      impl.routingControlArn(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest
  ): zio.aws.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest.ReadOnly =
    new Wrapper(impl)
}
