package zio.aws.route53recoverycontrolconfig.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.route53recoverycontrolconfig.model.primitives.{
  __integer,
  __stringMin1Max64PatternS,
  __boolean,
  __stringMin1Max256PatternAZaZ09
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ControlPanel(
    clusterArn: Optional[__stringMin1Max256PatternAZaZ09] = Optional.Absent,
    controlPanelArn: Optional[__stringMin1Max256PatternAZaZ09] =
      Optional.Absent,
    defaultControlPanel: Optional[__boolean] = Optional.Absent,
    name: Optional[__stringMin1Max64PatternS] = Optional.Absent,
    routingControlCount: Optional[__integer] = Optional.Absent,
    status: Optional[zio.aws.route53recoverycontrolconfig.model.Status] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.ControlPanel = {
    import ControlPanel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ControlPanel
      .builder()
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(controlPanelArn.map(value => value: java.lang.String))(
        _.controlPanelArn
      )
      .optionallyWith(
        defaultControlPanel.map(value => value: java.lang.Boolean)
      )(_.defaultControlPanel)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(routingControlCount.map(value => value: Integer))(
        _.routingControlCount
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.ControlPanel.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.ControlPanel
      .wrap(buildAwsValue())
}
object ControlPanel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ControlPanel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53recoverycontrolconfig.model.ControlPanel =
      zio.aws.route53recoverycontrolconfig.model.ControlPanel(
        clusterArn.map(value => value),
        controlPanelArn.map(value => value),
        defaultControlPanel.map(value => value),
        name.map(value => value),
        routingControlCount.map(value => value),
        status.map(value => value)
      )
    def clusterArn: Optional[__stringMin1Max256PatternAZaZ09]
    def controlPanelArn: Optional[__stringMin1Max256PatternAZaZ09]
    def defaultControlPanel: Optional[__boolean]
    def name: Optional[__stringMin1Max64PatternS]
    def routingControlCount: Optional[__integer]
    def status: Optional[zio.aws.route53recoverycontrolconfig.model.Status]
    def getClusterArn: ZIO[Any, AwsError, __stringMin1Max256PatternAZaZ09] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getControlPanelArn
        : ZIO[Any, AwsError, __stringMin1Max256PatternAZaZ09] =
      AwsError.unwrapOptionField("controlPanelArn", controlPanelArn)
    def getDefaultControlPanel: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("defaultControlPanel", defaultControlPanel)
    def getName: ZIO[Any, AwsError, __stringMin1Max64PatternS] =
      AwsError.unwrapOptionField("name", name)
    def getRoutingControlCount: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("routingControlCount", routingControlCount)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.Status
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ControlPanel
  ) extends zio.aws.route53recoverycontrolconfig.model.ControlPanel.ReadOnly {
    override val clusterArn: Optional[__stringMin1Max256PatternAZaZ09] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterArn())
        .map(value => value: __stringMin1Max256PatternAZaZ09)
    override val controlPanelArn: Optional[__stringMin1Max256PatternAZaZ09] =
      zio.aws.core.internal
        .optionalFromNullable(impl.controlPanelArn())
        .map(value => value: __stringMin1Max256PatternAZaZ09)
    override val defaultControlPanel: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultControlPanel())
        .map(value => value: __boolean)
    override val name: Optional[__stringMin1Max64PatternS] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value => value: __stringMin1Max64PatternS)
    override val routingControlCount: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routingControlCount())
        .map(value => value: __integer)
    override val status
        : Optional[zio.aws.route53recoverycontrolconfig.model.Status] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.route53recoverycontrolconfig.model.Status.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ControlPanel
  ): zio.aws.route53recoverycontrolconfig.model.ControlPanel.ReadOnly =
    new Wrapper(impl)
}
