package zio.aws.route53recoverycontrolconfig.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateControlPanelResponse(
    controlPanel: Optional[
      zio.aws.route53recoverycontrolconfig.model.ControlPanel
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateControlPanelResponse = {
    import UpdateControlPanelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateControlPanelResponse
      .builder()
      .optionallyWith(controlPanel.map(value => value.buildAwsValue()))(
        _.controlPanel
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.UpdateControlPanelResponse.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.UpdateControlPanelResponse
      .wrap(buildAwsValue())
}
object UpdateControlPanelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateControlPanelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.UpdateControlPanelResponse =
      zio.aws.route53recoverycontrolconfig.model
        .UpdateControlPanelResponse(controlPanel.map(value => value.asEditable))
    def controlPanel: Optional[
      zio.aws.route53recoverycontrolconfig.model.ControlPanel.ReadOnly
    ]
    def getControlPanel: ZIO[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.ControlPanel.ReadOnly
    ] = AwsError.unwrapOptionField("controlPanel", controlPanel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateControlPanelResponse
  ) extends zio.aws.route53recoverycontrolconfig.model.UpdateControlPanelResponse.ReadOnly {
    override val controlPanel: Optional[
      zio.aws.route53recoverycontrolconfig.model.ControlPanel.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.controlPanel())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.ControlPanel.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateControlPanelResponse
  ): zio.aws.route53recoverycontrolconfig.model.UpdateControlPanelResponse.ReadOnly =
    new Wrapper(impl)
}
