package zio.aws.route53recoverycontrolconfig.model
import zio.aws.route53recoverycontrolconfig.model.primitives.{
  __stringMin0Max256PatternS,
  __string,
  __stringMin1Max64PatternS
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateSafetyRuleRequest(
    assertionRule: Optional[
      zio.aws.route53recoverycontrolconfig.model.NewAssertionRule
    ] = Optional.Absent,
    clientToken: Optional[__stringMin1Max64PatternS] = Optional.Absent,
    gatingRule: Optional[
      zio.aws.route53recoverycontrolconfig.model.NewGatingRule
    ] = Optional.Absent,
    tags: Optional[Map[__string, __stringMin0Max256PatternS]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateSafetyRuleRequest = {
    import CreateSafetyRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateSafetyRuleRequest
      .builder()
      .optionallyWith(assertionRule.map(value => value.buildAwsValue()))(
        _.assertionRule
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(gatingRule.map(value => value.buildAwsValue()))(
        _.gatingRule
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.CreateSafetyRuleRequest.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.CreateSafetyRuleRequest
      .wrap(buildAwsValue())
}
object CreateSafetyRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateSafetyRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.CreateSafetyRuleRequest =
      zio.aws.route53recoverycontrolconfig.model.CreateSafetyRuleRequest(
        assertionRule.map(value => value.asEditable),
        clientToken.map(value => value),
        gatingRule.map(value => value.asEditable),
        tags.map(value => value)
      )
    def assertionRule: Optional[
      zio.aws.route53recoverycontrolconfig.model.NewAssertionRule.ReadOnly
    ]
    def clientToken: Optional[__stringMin1Max64PatternS]
    def gatingRule: Optional[
      zio.aws.route53recoverycontrolconfig.model.NewGatingRule.ReadOnly
    ]
    def tags: Optional[Map[__string, __stringMin0Max256PatternS]]
    def getAssertionRule: ZIO[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.NewAssertionRule.ReadOnly
    ] = AwsError.unwrapOptionField("assertionRule", assertionRule)
    def getClientToken: ZIO[Any, AwsError, __stringMin1Max64PatternS] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getGatingRule: ZIO[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.NewGatingRule.ReadOnly
    ] = AwsError.unwrapOptionField("gatingRule", gatingRule)
    def getTags: ZIO[Any, AwsError, Map[__string, __stringMin0Max256PatternS]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateSafetyRuleRequest
  ) extends zio.aws.route53recoverycontrolconfig.model.CreateSafetyRuleRequest.ReadOnly {
    override val assertionRule: Optional[
      zio.aws.route53recoverycontrolconfig.model.NewAssertionRule.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.assertionRule())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.NewAssertionRule.wrap(value)
      )
    override val clientToken: Optional[__stringMin1Max64PatternS] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientToken())
        .map(value => value: __stringMin1Max64PatternS)
    override val gatingRule: Optional[
      zio.aws.route53recoverycontrolconfig.model.NewGatingRule.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.gatingRule())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.NewGatingRule.wrap(value)
      )
    override val tags: Optional[Map[__string, __stringMin0Max256PatternS]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> (value: __stringMin0Max256PatternS)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateSafetyRuleRequest
  ): zio.aws.route53recoverycontrolconfig.model.CreateSafetyRuleRequest.ReadOnly =
    new Wrapper(impl)
}
