package zio.aws.route53recoverycontrolconfig.model
import zio.aws.route53recoverycontrolconfig.model.primitives.{
  __stringMin1Max256PatternAZaZ09,
  __stringMin1Max64PatternS
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateRoutingControlRequest(
    clientToken: Optional[__stringMin1Max64PatternS] = Optional.Absent,
    clusterArn: __stringMin1Max256PatternAZaZ09,
    controlPanelArn: Optional[__stringMin1Max256PatternAZaZ09] =
      Optional.Absent,
    routingControlName: __stringMin1Max64PatternS
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateRoutingControlRequest = {
    import CreateRoutingControlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateRoutingControlRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .clusterArn(clusterArn: java.lang.String)
      .optionallyWith(controlPanelArn.map(value => value: java.lang.String))(
        _.controlPanelArn
      )
      .routingControlName(routingControlName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.CreateRoutingControlRequest.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.CreateRoutingControlRequest
      .wrap(buildAwsValue())
}
object CreateRoutingControlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateRoutingControlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.CreateRoutingControlRequest =
      zio.aws.route53recoverycontrolconfig.model.CreateRoutingControlRequest(
        clientToken.map(value => value),
        clusterArn,
        controlPanelArn.map(value => value),
        routingControlName
      )
    def clientToken: Optional[__stringMin1Max64PatternS]
    def clusterArn: __stringMin1Max256PatternAZaZ09
    def controlPanelArn: Optional[__stringMin1Max256PatternAZaZ09]
    def routingControlName: __stringMin1Max64PatternS
    def getClientToken: ZIO[Any, AwsError, __stringMin1Max64PatternS] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getClusterArn: ZIO[Any, Nothing, __stringMin1Max256PatternAZaZ09] =
      ZIO.succeed(clusterArn)
    def getControlPanelArn
        : ZIO[Any, AwsError, __stringMin1Max256PatternAZaZ09] =
      AwsError.unwrapOptionField("controlPanelArn", controlPanelArn)
    def getRoutingControlName: ZIO[Any, Nothing, __stringMin1Max64PatternS] =
      ZIO.succeed(routingControlName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateRoutingControlRequest
  ) extends zio.aws.route53recoverycontrolconfig.model.CreateRoutingControlRequest.ReadOnly {
    override val clientToken: Optional[__stringMin1Max64PatternS] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientToken())
        .map(value => value: __stringMin1Max64PatternS)
    override val clusterArn: __stringMin1Max256PatternAZaZ09 =
      impl.clusterArn(): __stringMin1Max256PatternAZaZ09
    override val controlPanelArn: Optional[__stringMin1Max256PatternAZaZ09] =
      zio.aws.core.internal
        .optionalFromNullable(impl.controlPanelArn())
        .map(value => value: __stringMin1Max256PatternAZaZ09)
    override val routingControlName: __stringMin1Max64PatternS =
      impl.routingControlName(): __stringMin1Max64PatternS
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateRoutingControlRequest
  ): zio.aws.route53recoverycontrolconfig.model.CreateRoutingControlRequest.ReadOnly =
    new Wrapper(impl)
}
