package zio.aws.route53recoverycontrolconfig.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSafetyRuleResponse(
    assertionRule: Optional[
      zio.aws.route53recoverycontrolconfig.model.AssertionRule
    ] = Optional.Absent,
    gatingRule: Optional[
      zio.aws.route53recoverycontrolconfig.model.GatingRule
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse = {
    import UpdateSafetyRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse
      .builder()
      .optionallyWith(assertionRule.map(value => value.buildAwsValue()))(
        _.assertionRule
      )
      .optionallyWith(gatingRule.map(value => value.buildAwsValue()))(
        _.gatingRule
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse
      .wrap(buildAwsValue())
}
object UpdateSafetyRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse =
      zio.aws.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse(
        assertionRule.map(value => value.asEditable),
        gatingRule.map(value => value.asEditable)
      )
    def assertionRule: Optional[
      zio.aws.route53recoverycontrolconfig.model.AssertionRule.ReadOnly
    ]
    def gatingRule: Optional[
      zio.aws.route53recoverycontrolconfig.model.GatingRule.ReadOnly
    ]
    def getAssertionRule: ZIO[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.AssertionRule.ReadOnly
    ] = AwsError.unwrapOptionField("assertionRule", assertionRule)
    def getGatingRule: ZIO[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.GatingRule.ReadOnly
    ] = AwsError.unwrapOptionField("gatingRule", gatingRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse
  ) extends zio.aws.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse.ReadOnly {
    override val assertionRule: Optional[
      zio.aws.route53recoverycontrolconfig.model.AssertionRule.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.assertionRule())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.AssertionRule.wrap(value)
      )
    override val gatingRule: Optional[
      zio.aws.route53recoverycontrolconfig.model.GatingRule.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.gatingRule())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.GatingRule.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse
  ): zio.aws.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse.ReadOnly =
    new Wrapper(impl)
}
