package zio.aws.route53recoverycontrolconfig.model
import java.lang.Integer
import zio.aws.route53recoverycontrolconfig.model.primitives.{
  MaxResults,
  __string
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListControlPanelsRequest(
    clusterArn: Option[__string] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsRequest = {
    import ListControlPanelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsRequest
      .builder()
      .optionallyWith(
        clusterArn.map(value => __string.unwrap(value): java.lang.String)
      )(_.clusterArn)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.ListControlPanelsRequest.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.ListControlPanelsRequest
      .wrap(buildAwsValue())
}
object ListControlPanelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.ListControlPanelsRequest =
      zio.aws.route53recoverycontrolconfig.model.ListControlPanelsRequest(
        clusterArn.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def clusterArn: Option[__string]
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def getClusterArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsRequest
  ) extends zio.aws.route53recoverycontrolconfig.model.ListControlPanelsRequest.ReadOnly {
    override val clusterArn: Option[__string] = scala
      .Option(impl.clusterArn())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.primitives.__string(value)
      )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.primitives.MaxResults(value)
      )
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.primitives.__string(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsRequest
  ): zio.aws.route53recoverycontrolconfig.model.ListControlPanelsRequest.ReadOnly =
    new Wrapper(impl)
}
