package zio.aws.route53recoverycontrolconfig.model
import zio.aws.route53recoverycontrolconfig.model.primitives.{
  __stringMin1Max8096PatternS,
  __stringMax36PatternS
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAssociatedRoute53HealthChecksResponse(
    healthCheckIds: Option[Iterable[__stringMax36PatternS]] = None,
    nextToken: Option[__stringMin1Max8096PatternS] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse = {
    import ListAssociatedRoute53HealthChecksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse
      .builder()
      .optionallyWith(
        healthCheckIds.map(value =>
          value.map { item =>
            __stringMax36PatternS.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.healthCheckIds)
      .optionallyWith(
        nextToken.map(value =>
          __stringMin1Max8096PatternS.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse
      .wrap(buildAwsValue())
}
object ListAssociatedRoute53HealthChecksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse =
      zio.aws.route53recoverycontrolconfig.model
        .ListAssociatedRoute53HealthChecksResponse(
          healthCheckIds.map(value => value),
          nextToken.map(value => value)
        )
    def healthCheckIds: Option[List[__stringMax36PatternS]]
    def nextToken: Option[__stringMin1Max8096PatternS]
    def getHealthCheckIds: ZIO[Any, AwsError, List[__stringMax36PatternS]] =
      AwsError.unwrapOptionField("healthCheckIds", healthCheckIds)
    def getNextToken: ZIO[Any, AwsError, __stringMin1Max8096PatternS] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse
  ) extends zio.aws.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse.ReadOnly {
    override val healthCheckIds: Option[List[__stringMax36PatternS]] = scala
      .Option(impl.healthCheckIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53recoverycontrolconfig.model.primitives
            .__stringMax36PatternS(item)
        }.toList
      )
    override val nextToken: Option[__stringMin1Max8096PatternS] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.primitives
          .__stringMin1Max8096PatternS(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse
  ): zio.aws.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse.ReadOnly =
    new Wrapper(impl)
}
