package zio.aws.route53recoverycontrolconfig.model
import zio.aws.route53recoverycontrolconfig.model.primitives.{
  __stringMin0Max256PatternS,
  __string
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: __string,
    tags: Map[__string, __stringMin0Max256PatternS]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.TagResourceRequest
      .builder()
      .resourceArn(__string.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (__string
              .unwrap(key): java.lang.String) -> (__stringMin0Max256PatternS
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.TagResourceRequest.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.TagResourceRequest
      .wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.TagResourceRequest =
      zio.aws.route53recoverycontrolconfig.model
        .TagResourceRequest(resourceArn, tags)
    def resourceArn: __string
    def tags: Map[__string, __stringMin0Max256PatternS]
    def getResourceArn: ZIO[Any, Nothing, __string] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[__string, __stringMin0Max256PatternS]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.TagResourceRequest
  ) extends zio.aws.route53recoverycontrolconfig.model.TagResourceRequest.ReadOnly {
    override val resourceArn: __string =
      zio.aws.route53recoverycontrolconfig.model.primitives
        .__string(impl.resourceArn())
    override val tags: Map[__string, __stringMin0Max256PatternS] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.route53recoverycontrolconfig.model.primitives.__string(
          key
        ) -> zio.aws.route53recoverycontrolconfig.model.primitives
          .__stringMin0Max256PatternS(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.TagResourceRequest
  ): zio.aws.route53recoverycontrolconfig.model.TagResourceRequest.ReadOnly =
    new Wrapper(impl)
}
