package zio.aws.route53recoverycontrolconfig.model
import zio.aws.route53recoverycontrolconfig.model.primitives.{
  __stringMin0Max256PatternS,
  __string,
  __stringMin1Max64PatternS
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateClusterRequest(
    clientToken: Optional[__stringMin1Max64PatternS] = Optional.Absent,
    clusterName: __stringMin1Max64PatternS,
    tags: Optional[Map[__string, __stringMin0Max256PatternS]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateClusterRequest = {
    import CreateClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateClusterRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .clusterName(clusterName: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.CreateClusterRequest.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.CreateClusterRequest
      .wrap(buildAwsValue())
}
object CreateClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.CreateClusterRequest =
      zio.aws.route53recoverycontrolconfig.model.CreateClusterRequest(
        clientToken.map(value => value),
        clusterName,
        tags.map(value => value)
      )
    def clientToken: Optional[__stringMin1Max64PatternS]
    def clusterName: __stringMin1Max64PatternS
    def tags: Optional[Map[__string, __stringMin0Max256PatternS]]
    def getClientToken: ZIO[Any, AwsError, __stringMin1Max64PatternS] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getClusterName: ZIO[Any, Nothing, __stringMin1Max64PatternS] =
      ZIO.succeed(clusterName)
    def getTags: ZIO[Any, AwsError, Map[__string, __stringMin0Max256PatternS]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateClusterRequest
  ) extends zio.aws.route53recoverycontrolconfig.model.CreateClusterRequest.ReadOnly {
    override val clientToken: Optional[__stringMin1Max64PatternS] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientToken())
        .map(value => value: __stringMin1Max64PatternS)
    override val clusterName: __stringMin1Max64PatternS =
      impl.clusterName(): __stringMin1Max64PatternS
    override val tags: Optional[Map[__string, __stringMin0Max256PatternS]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> (value: __stringMin0Max256PatternS)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateClusterRequest
  ): zio.aws.route53recoverycontrolconfig.model.CreateClusterRequest.ReadOnly =
    new Wrapper(impl)
}
