package zio.aws.route53recoverycontrolconfig.model
import zio.aws.route53recoverycontrolconfig.model.primitives.__stringMin1Max8096PatternS
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSafetyRulesResponse(
    nextToken: Optional[__stringMin1Max8096PatternS] = Optional.Absent,
    safetyRules: Optional[
      Iterable[zio.aws.route53recoverycontrolconfig.model.Rule]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesResponse = {
    import ListSafetyRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        safetyRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.safetyRules)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.ListSafetyRulesResponse.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.ListSafetyRulesResponse
      .wrap(buildAwsValue())
}
object ListSafetyRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.ListSafetyRulesResponse =
      zio.aws.route53recoverycontrolconfig.model.ListSafetyRulesResponse(
        nextToken.map(value => value),
        safetyRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[__stringMin1Max8096PatternS]
    def safetyRules: Optional[
      List[zio.aws.route53recoverycontrolconfig.model.Rule.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, __stringMin1Max8096PatternS] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSafetyRules: ZIO[Any, AwsError, List[
      zio.aws.route53recoverycontrolconfig.model.Rule.ReadOnly
    ]] = AwsError.unwrapOptionField("safetyRules", safetyRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesResponse
  ) extends zio.aws.route53recoverycontrolconfig.model.ListSafetyRulesResponse.ReadOnly {
    override val nextToken: Optional[__stringMin1Max8096PatternS] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value => value: __stringMin1Max8096PatternS)
    override val safetyRules: Optional[
      List[zio.aws.route53recoverycontrolconfig.model.Rule.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.safetyRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53recoverycontrolconfig.model.Rule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesResponse
  ): zio.aws.route53recoverycontrolconfig.model.ListSafetyRulesResponse.ReadOnly =
    new Wrapper(impl)
}
