package zio.aws.route53recoverycontrolconfig.model
import zio.aws.route53recoverycontrolconfig.model.primitives.{
  __stringMin1Max64PatternS,
  __stringMin1Max256PatternAZaZ09
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RoutingControl(
    controlPanelArn: Optional[__stringMin1Max256PatternAZaZ09] =
      Optional.Absent,
    name: Optional[__stringMin1Max64PatternS] = Optional.Absent,
    routingControlArn: Optional[__stringMin1Max256PatternAZaZ09] =
      Optional.Absent,
    status: Optional[zio.aws.route53recoverycontrolconfig.model.Status] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.RoutingControl = {
    import RoutingControl.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.RoutingControl
      .builder()
      .optionallyWith(controlPanelArn.map(value => value: java.lang.String))(
        _.controlPanelArn
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(routingControlArn.map(value => value: java.lang.String))(
        _.routingControlArn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.RoutingControl.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.RoutingControl
      .wrap(buildAwsValue())
}
object RoutingControl {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.RoutingControl
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53recoverycontrolconfig.model.RoutingControl =
      zio.aws.route53recoverycontrolconfig.model.RoutingControl(
        controlPanelArn.map(value => value),
        name.map(value => value),
        routingControlArn.map(value => value),
        status.map(value => value)
      )
    def controlPanelArn: Optional[__stringMin1Max256PatternAZaZ09]
    def name: Optional[__stringMin1Max64PatternS]
    def routingControlArn: Optional[__stringMin1Max256PatternAZaZ09]
    def status: Optional[zio.aws.route53recoverycontrolconfig.model.Status]
    def getControlPanelArn
        : ZIO[Any, AwsError, __stringMin1Max256PatternAZaZ09] =
      AwsError.unwrapOptionField("controlPanelArn", controlPanelArn)
    def getName: ZIO[Any, AwsError, __stringMin1Max64PatternS] =
      AwsError.unwrapOptionField("name", name)
    def getRoutingControlArn
        : ZIO[Any, AwsError, __stringMin1Max256PatternAZaZ09] =
      AwsError.unwrapOptionField("routingControlArn", routingControlArn)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.Status
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.RoutingControl
  ) extends zio.aws.route53recoverycontrolconfig.model.RoutingControl.ReadOnly {
    override val controlPanelArn: Optional[__stringMin1Max256PatternAZaZ09] =
      zio.aws.core.internal
        .optionalFromNullable(impl.controlPanelArn())
        .map(value => value: __stringMin1Max256PatternAZaZ09)
    override val name: Optional[__stringMin1Max64PatternS] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value => value: __stringMin1Max64PatternS)
    override val routingControlArn: Optional[__stringMin1Max256PatternAZaZ09] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routingControlArn())
        .map(value => value: __stringMin1Max256PatternAZaZ09)
    override val status
        : Optional[zio.aws.route53recoverycontrolconfig.model.Status] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.route53recoverycontrolconfig.model.Status.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.RoutingControl
  ): zio.aws.route53recoverycontrolconfig.model.RoutingControl.ReadOnly =
    new Wrapper(impl)
}
