package zio.aws.route53recoverycontrolconfig.model
import scala.jdk.CollectionConverters._
sealed trait RuleType {
  def unwrap
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.RuleType
}
object RuleType {
  def wrap(
      value: software.amazon.awssdk.services.route53recoverycontrolconfig.model.RuleType
  ): zio.aws.route53recoverycontrolconfig.model.RuleType = value match {
    case software.amazon.awssdk.services.route53recoverycontrolconfig.model.RuleType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53recoverycontrolconfig.model.RuleType.ATLEAST =>
      val r = ATLEAST
      r
    case software.amazon.awssdk.services.route53recoverycontrolconfig.model.RuleType.AND =>
      val r = AND
      r
    case software.amazon.awssdk.services.route53recoverycontrolconfig.model.RuleType.OR =>
      val r = OR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.route53recoverycontrolconfig.model.RuleType {
    override def unwrap
        : software.amazon.awssdk.services.route53recoverycontrolconfig.model.RuleType =
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.RuleType.UNKNOWN_TO_SDK_VERSION
  }
  case object ATLEAST
      extends zio.aws.route53recoverycontrolconfig.model.RuleType {
    override def unwrap
        : software.amazon.awssdk.services.route53recoverycontrolconfig.model.RuleType =
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.RuleType.ATLEAST
  }
  case object AND extends zio.aws.route53recoverycontrolconfig.model.RuleType {
    override def unwrap
        : software.amazon.awssdk.services.route53recoverycontrolconfig.model.RuleType =
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.RuleType.AND
  }
  case object OR extends zio.aws.route53recoverycontrolconfig.model.RuleType {
    override def unwrap
        : software.amazon.awssdk.services.route53recoverycontrolconfig.model.RuleType =
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.RuleType.OR
  }
}
