package zio.aws.route53recoverycontrolconfig.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Rule(
    assertion: Option[
      zio.aws.route53recoverycontrolconfig.model.AssertionRule
    ] = None,
    gating: Option[zio.aws.route53recoverycontrolconfig.model.GatingRule] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.Rule = {
    import Rule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.Rule
      .builder()
      .optionallyWith(assertion.map(value => value.buildAwsValue()))(
        _.assertion
      )
      .optionallyWith(gating.map(value => value.buildAwsValue()))(_.gating)
      .build()
  }
  def asReadOnly: zio.aws.route53recoverycontrolconfig.model.Rule.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.Rule.wrap(buildAwsValue())
}
object Rule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.Rule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53recoverycontrolconfig.model.Rule =
      zio.aws.route53recoverycontrolconfig.model.Rule(
        assertion.map(value => value.asEditable),
        gating.map(value => value.asEditable)
      )
    def assertion: Option[
      zio.aws.route53recoverycontrolconfig.model.AssertionRule.ReadOnly
    ]
    def gating
        : Option[zio.aws.route53recoverycontrolconfig.model.GatingRule.ReadOnly]
    def getAssertion: ZIO[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.AssertionRule.ReadOnly
    ] = AwsError.unwrapOptionField("assertion", assertion)
    def getGating: ZIO[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.GatingRule.ReadOnly
    ] = AwsError.unwrapOptionField("gating", gating)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.Rule
  ) extends zio.aws.route53recoverycontrolconfig.model.Rule.ReadOnly {
    override val assertion: Option[
      zio.aws.route53recoverycontrolconfig.model.AssertionRule.ReadOnly
    ] = scala
      .Option(impl.assertion())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.AssertionRule.wrap(value)
      )
    override val gating: Option[
      zio.aws.route53recoverycontrolconfig.model.GatingRule.ReadOnly
    ] = scala
      .Option(impl.gating())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.GatingRule.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.Rule
  ): zio.aws.route53recoverycontrolconfig.model.Rule.ReadOnly = new Wrapper(
    impl
  )
}
