package zio.aws.route53recoverycontrolconfig.model
import java.lang.Integer
import zio.aws.route53recoverycontrolconfig.model.primitives.{
  __string,
  MaxResults
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAssociatedRoute53HealthChecksRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None,
    routingControlArn: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest = {
    import ListAssociatedRoute53HealthChecksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .routingControlArn(routingControlArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest
      .wrap(buildAwsValue())
}
object ListAssociatedRoute53HealthChecksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest =
      zio.aws.route53recoverycontrolconfig.model
        .ListAssociatedRoute53HealthChecksRequest(
          maxResults.map(value => value),
          nextToken.map(value => value),
          routingControlArn
        )
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def routingControlArn: __string
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRoutingControlArn: ZIO[Any, Nothing, __string] =
      ZIO.succeed(routingControlArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest
  ) extends zio.aws.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.primitives.MaxResults(value)
      )
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
    override val routingControlArn: __string =
      impl.routingControlArn(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest
  ): zio.aws.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest.ReadOnly =
    new Wrapper(impl)
}
