package zio.aws.route53recoverycontrolconfig.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateRoutingControlResponse(
    routingControl: Option[
      zio.aws.route53recoverycontrolconfig.model.RoutingControl
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateRoutingControlResponse = {
    import CreateRoutingControlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateRoutingControlResponse
      .builder()
      .optionallyWith(routingControl.map(value => value.buildAwsValue()))(
        _.routingControl
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.CreateRoutingControlResponse.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.CreateRoutingControlResponse
      .wrap(buildAwsValue())
}
object CreateRoutingControlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateRoutingControlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.CreateRoutingControlResponse =
      zio.aws.route53recoverycontrolconfig.model.CreateRoutingControlResponse(
        routingControl.map(value => value.asEditable)
      )
    def routingControl: Option[
      zio.aws.route53recoverycontrolconfig.model.RoutingControl.ReadOnly
    ]
    def getRoutingControl: ZIO[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.RoutingControl.ReadOnly
    ] = AwsError.unwrapOptionField("routingControl", routingControl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateRoutingControlResponse
  ) extends zio.aws.route53recoverycontrolconfig.model.CreateRoutingControlResponse.ReadOnly {
    override val routingControl: Option[
      zio.aws.route53recoverycontrolconfig.model.RoutingControl.ReadOnly
    ] = scala
      .Option(impl.routingControl())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.RoutingControl.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateRoutingControlResponse
  ): zio.aws.route53recoverycontrolconfig.model.CreateRoutingControlResponse.ReadOnly =
    new Wrapper(impl)
}
