package zio.aws.route53recoverycontrolconfig.model
import zio.aws.route53recoverycontrolconfig.model.primitives.{
  __stringMin1Max64PatternS,
  __stringMin1Max256PatternAZaZ09
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Cluster(
    clusterArn: Option[__stringMin1Max256PatternAZaZ09] = None,
    clusterEndpoints: Option[
      Iterable[zio.aws.route53recoverycontrolconfig.model.ClusterEndpoint]
    ] = None,
    name: Option[__stringMin1Max64PatternS] = None,
    status: Option[zio.aws.route53recoverycontrolconfig.model.Status] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.Cluster = {
    import Cluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.Cluster
      .builder()
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(
        clusterEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterEndpoints)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.route53recoverycontrolconfig.model.Cluster.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.Cluster.wrap(buildAwsValue())
}
object Cluster {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.Cluster
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53recoverycontrolconfig.model.Cluster =
      zio.aws.route53recoverycontrolconfig.model.Cluster(
        clusterArn.map(value => value),
        clusterEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value),
        status.map(value => value)
      )
    def clusterArn: Option[__stringMin1Max256PatternAZaZ09]
    def clusterEndpoints: Option[
      List[zio.aws.route53recoverycontrolconfig.model.ClusterEndpoint.ReadOnly]
    ]
    def name: Option[__stringMin1Max64PatternS]
    def status: Option[zio.aws.route53recoverycontrolconfig.model.Status]
    def getClusterArn: ZIO[Any, AwsError, __stringMin1Max256PatternAZaZ09] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getClusterEndpoints: ZIO[Any, AwsError, List[
      zio.aws.route53recoverycontrolconfig.model.ClusterEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("clusterEndpoints", clusterEndpoints)
    def getName: ZIO[Any, AwsError, __stringMin1Max64PatternS] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.Status
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.Cluster
  ) extends zio.aws.route53recoverycontrolconfig.model.Cluster.ReadOnly {
    override val clusterArn: Option[__stringMin1Max256PatternAZaZ09] = scala
      .Option(impl.clusterArn())
      .map(value => value: __stringMin1Max256PatternAZaZ09)
    override val clusterEndpoints: Option[
      List[zio.aws.route53recoverycontrolconfig.model.ClusterEndpoint.ReadOnly]
    ] = scala
      .Option(impl.clusterEndpoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53recoverycontrolconfig.model.ClusterEndpoint.wrap(item)
        }.toList
      )
    override val name: Option[__stringMin1Max64PatternS] =
      scala.Option(impl.name()).map(value => value: __stringMin1Max64PatternS)
    override val status
        : Option[zio.aws.route53recoverycontrolconfig.model.Status] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.Status.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.Cluster
  ): zio.aws.route53recoverycontrolconfig.model.Cluster.ReadOnly = new Wrapper(
    impl
  )
}
