package zio.aws.route53recoverycontrolconfig.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateClusterResponse(
    cluster: Option[zio.aws.route53recoverycontrolconfig.model.Cluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateClusterResponse = {
    import CreateClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateClusterResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.CreateClusterResponse.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.CreateClusterResponse
      .wrap(buildAwsValue())
}
object CreateClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.CreateClusterResponse =
      zio.aws.route53recoverycontrolconfig.model
        .CreateClusterResponse(cluster.map(value => value.asEditable))
    def cluster
        : Option[zio.aws.route53recoverycontrolconfig.model.Cluster.ReadOnly]
    def getCluster: ZIO[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.Cluster.ReadOnly
    ] = AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateClusterResponse
  ) extends zio.aws.route53recoverycontrolconfig.model.CreateClusterResponse.ReadOnly {
    override val cluster
        : Option[zio.aws.route53recoverycontrolconfig.model.Cluster.ReadOnly] =
      scala
        .Option(impl.cluster())
        .map(value =>
          zio.aws.route53recoverycontrolconfig.model.Cluster.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateClusterResponse
  ): zio.aws.route53recoverycontrolconfig.model.CreateClusterResponse.ReadOnly =
    new Wrapper(impl)
}
