package zio.aws.route53recoverycontrolconfig.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateSafetyRuleResponse(
    assertionRule: Option[
      zio.aws.route53recoverycontrolconfig.model.AssertionRule
    ] = None,
    gatingRule: Option[zio.aws.route53recoverycontrolconfig.model.GatingRule] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse = {
    import UpdateSafetyRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse
      .builder()
      .optionallyWith(assertionRule.map(value => value.buildAwsValue()))(
        _.assertionRule
      )
      .optionallyWith(gatingRule.map(value => value.buildAwsValue()))(
        _.gatingRule
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse
      .wrap(buildAwsValue())
}
object UpdateSafetyRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse =
      zio.aws.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse(
        assertionRule.map(value => value.asEditable),
        gatingRule.map(value => value.asEditable)
      )
    def assertionRule: Option[
      zio.aws.route53recoverycontrolconfig.model.AssertionRule.ReadOnly
    ]
    def gatingRule
        : Option[zio.aws.route53recoverycontrolconfig.model.GatingRule.ReadOnly]
    def getAssertionRule: ZIO[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.AssertionRule.ReadOnly
    ] = AwsError.unwrapOptionField("assertionRule", assertionRule)
    def getGatingRule: ZIO[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.GatingRule.ReadOnly
    ] = AwsError.unwrapOptionField("gatingRule", gatingRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse
  ) extends zio.aws.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse.ReadOnly {
    override val assertionRule: Option[
      zio.aws.route53recoverycontrolconfig.model.AssertionRule.ReadOnly
    ] = scala
      .Option(impl.assertionRule())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.AssertionRule.wrap(value)
      )
    override val gatingRule: Option[
      zio.aws.route53recoverycontrolconfig.model.GatingRule.ReadOnly
    ] = scala
      .Option(impl.gatingRule())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.GatingRule.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse
  ): zio.aws.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse.ReadOnly =
    new Wrapper(impl)
}
