package zio.aws.route53recoverycluster.model
import zio.aws.route53recoverycluster.model.primitives.{
  MaxResults,
  PageToken,
  Arn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRoutingControlsRequest(
    controlPanelArn: Optional[Arn] = Optional.Absent,
    nextToken: Optional[PageToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycluster.model.ListRoutingControlsRequest = {
    import ListRoutingControlsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycluster.model.ListRoutingControlsRequest
      .builder()
      .optionallyWith(
        controlPanelArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.controlPanelArn)
      .optionallyWith(
        nextToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycluster.model.ListRoutingControlsRequest.ReadOnly =
    zio.aws.route53recoverycluster.model.ListRoutingControlsRequest
      .wrap(buildAwsValue())
}
object ListRoutingControlsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycluster.model.ListRoutingControlsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycluster.model.ListRoutingControlsRequest =
      zio.aws.route53recoverycluster.model.ListRoutingControlsRequest(
        controlPanelArn.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def controlPanelArn: Optional[Arn]
    def nextToken: Optional[PageToken]
    def maxResults: Optional[MaxResults]
    def getControlPanelArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("controlPanelArn", controlPanelArn)
    def getNextToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycluster.model.ListRoutingControlsRequest
  ) extends zio.aws.route53recoverycluster.model.ListRoutingControlsRequest.ReadOnly {
    override val controlPanelArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.controlPanelArn())
      .map(value => zio.aws.route53recoverycluster.model.primitives.Arn(value))
    override val nextToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.route53recoverycluster.model.primitives.PageToken(value)
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.route53recoverycluster.model.primitives.MaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycluster.model.ListRoutingControlsRequest
  ): zio.aws.route53recoverycluster.model.ListRoutingControlsRequest.ReadOnly =
    new Wrapper(impl)
}
