package zio.aws.route53recoverycluster.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53recoverycluster.model.primitives.{
  Owner,
  RoutingControlName,
  ControlPanelName,
  Arn
}
import scala.jdk.CollectionConverters._
final case class RoutingControl(
    controlPanelArn: Optional[Arn] = Optional.Absent,
    controlPanelName: Optional[ControlPanelName] = Optional.Absent,
    routingControlArn: Optional[Arn] = Optional.Absent,
    routingControlName: Optional[RoutingControlName] = Optional.Absent,
    routingControlState: Optional[
      zio.aws.route53recoverycluster.model.RoutingControlState
    ] = Optional.Absent,
    owner: Optional[Owner] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycluster.model.RoutingControl = {
    import RoutingControl.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycluster.model.RoutingControl
      .builder()
      .optionallyWith(
        controlPanelArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.controlPanelArn)
      .optionallyWith(
        controlPanelName.map(value =>
          ControlPanelName.unwrap(value): java.lang.String
        )
      )(_.controlPanelName)
      .optionallyWith(
        routingControlArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.routingControlArn)
      .optionallyWith(
        routingControlName.map(value =>
          RoutingControlName.unwrap(value): java.lang.String
        )
      )(_.routingControlName)
      .optionallyWith(routingControlState.map(value => value.unwrap))(
        _.routingControlState
      )
      .optionallyWith(
        owner.map(value => Owner.unwrap(value): java.lang.String)
      )(_.owner)
      .build()
  }
  def asReadOnly: zio.aws.route53recoverycluster.model.RoutingControl.ReadOnly =
    zio.aws.route53recoverycluster.model.RoutingControl.wrap(buildAwsValue())
}
object RoutingControl {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycluster.model.RoutingControl
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53recoverycluster.model.RoutingControl =
      zio.aws.route53recoverycluster.model.RoutingControl(
        controlPanelArn.map(value => value),
        controlPanelName.map(value => value),
        routingControlArn.map(value => value),
        routingControlName.map(value => value),
        routingControlState.map(value => value),
        owner.map(value => value)
      )
    def controlPanelArn: Optional[Arn]
    def controlPanelName: Optional[ControlPanelName]
    def routingControlArn: Optional[Arn]
    def routingControlName: Optional[RoutingControlName]
    def routingControlState
        : Optional[zio.aws.route53recoverycluster.model.RoutingControlState]
    def owner: Optional[Owner]
    def getControlPanelArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("controlPanelArn", controlPanelArn)
    def getControlPanelName: ZIO[Any, AwsError, ControlPanelName] =
      AwsError.unwrapOptionField("controlPanelName", controlPanelName)
    def getRoutingControlArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("routingControlArn", routingControlArn)
    def getRoutingControlName: ZIO[Any, AwsError, RoutingControlName] =
      AwsError.unwrapOptionField("routingControlName", routingControlName)
    def getRoutingControlState: ZIO[
      Any,
      AwsError,
      zio.aws.route53recoverycluster.model.RoutingControlState
    ] = AwsError.unwrapOptionField("routingControlState", routingControlState)
    def getOwner: ZIO[Any, AwsError, Owner] =
      AwsError.unwrapOptionField("owner", owner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycluster.model.RoutingControl
  ) extends zio.aws.route53recoverycluster.model.RoutingControl.ReadOnly {
    override val controlPanelArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.controlPanelArn())
      .map(value => zio.aws.route53recoverycluster.model.primitives.Arn(value))
    override val controlPanelName: Optional[ControlPanelName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.controlPanelName())
        .map(value =>
          zio.aws.route53recoverycluster.model.primitives
            .ControlPanelName(value)
        )
    override val routingControlArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.routingControlArn())
      .map(value => zio.aws.route53recoverycluster.model.primitives.Arn(value))
    override val routingControlName: Optional[RoutingControlName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routingControlName())
        .map(value =>
          zio.aws.route53recoverycluster.model.primitives
            .RoutingControlName(value)
        )
    override val routingControlState
        : Optional[zio.aws.route53recoverycluster.model.RoutingControlState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routingControlState())
        .map(value =>
          zio.aws.route53recoverycluster.model.RoutingControlState.wrap(value)
        )
    override val owner: Optional[Owner] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value =>
        zio.aws.route53recoverycluster.model.primitives.Owner(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycluster.model.RoutingControl
  ): zio.aws.route53recoverycluster.model.RoutingControl.ReadOnly = new Wrapper(
    impl
  )
}
