package zio.aws.route53recoverycluster
import zio.aws.route53recoverycluster.model.RoutingControl.ReadOnly
import software.amazon.awssdk.services.route53recoverycluster.{
  Route53RecoveryClusterAsyncClientBuilder,
  Route53RecoveryClusterAsyncClient
}
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.route53recoverycluster.model.{
  ListRoutingControlsResponse,
  GetRoutingControlStateRequest,
  GetRoutingControlStateResponse,
  UpdateRoutingControlStateResponse,
  UpdateRoutingControlStateRequest,
  ListRoutingControlsRequest,
  UpdateRoutingControlStatesResponse,
  UpdateRoutingControlStatesRequest,
  RoutingControl
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Route53RecoveryCluster extends AspectSupport[Route53RecoveryCluster] {
  val api: Route53RecoveryClusterAsyncClient
  def getRoutingControlState(
      request: zio.aws.route53recoverycluster.model.GetRoutingControlStateRequest
  ): IO[
    AwsError,
    zio.aws.route53recoverycluster.model.GetRoutingControlStateResponse.ReadOnly
  ]
  def listRoutingControls(
      request: zio.aws.route53recoverycluster.model.ListRoutingControlsRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def listRoutingControlsPaginated(
      request: zio.aws.route53recoverycluster.model.ListRoutingControlsRequest
  ): IO[
    AwsError,
    zio.aws.route53recoverycluster.model.ListRoutingControlsResponse.ReadOnly
  ]
  def updateRoutingControlState(
      request: zio.aws.route53recoverycluster.model.UpdateRoutingControlStateRequest
  ): IO[
    AwsError,
    zio.aws.route53recoverycluster.model.UpdateRoutingControlStateResponse.ReadOnly
  ]
  def updateRoutingControlStates(
      request: zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesRequest
  ): IO[
    AwsError,
    zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesResponse.ReadOnly
  ]
}
object Route53RecoveryCluster {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Route53RecoveryCluster] =
    customized(identity)
  def customized(
      customization: Route53RecoveryClusterAsyncClientBuilder => Route53RecoveryClusterAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Route53RecoveryCluster] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: Route53RecoveryClusterAsyncClientBuilder => Route53RecoveryClusterAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Route53RecoveryCluster] =
    for (
      awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
      builder = Route53RecoveryClusterAsyncClient
        .builder()
        .asyncConfiguration(
          software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
            .builder()
            .advancedOption(
              software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
              executor.asJava
            )
            .build()
        );
      b0 <- awsConfig.configure[
        Route53RecoveryClusterAsyncClient,
        Route53RecoveryClusterAsyncClientBuilder
      ](builder);
      b1 <- awsConfig.configureHttpClient[
        Route53RecoveryClusterAsyncClient,
        Route53RecoveryClusterAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
    )
      yield new Route53RecoveryClusterImpl(
        client,
        AwsCallAspect.identity,
        ZEnvironment.empty
      )
  private class Route53RecoveryClusterImpl[R](
      override val api: Route53RecoveryClusterAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Route53RecoveryCluster
      with AwsServiceBase[R] {
    override val serviceName: String = "Route53RecoveryCluster"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): Route53RecoveryClusterImpl[R1] =
      new Route53RecoveryClusterImpl(api, newAspect, r)
    def getRoutingControlState(
        request: zio.aws.route53recoverycluster.model.GetRoutingControlStateRequest
    ): IO[
      AwsError,
      zio.aws.route53recoverycluster.model.GetRoutingControlStateResponse.ReadOnly
    ] = asyncRequestResponse[
      GetRoutingControlStateRequest,
      GetRoutingControlStateResponse
    ]("getRoutingControlState", api.getRoutingControlState)(
      request.buildAwsValue()
    ).map(
      zio.aws.route53recoverycluster.model.GetRoutingControlStateResponse.wrap
    ).provideEnvironment(r)
    def listRoutingControls(
        request: zio.aws.route53recoverycluster.model.ListRoutingControlsRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncSimplePaginatedRequest[
      ListRoutingControlsRequest,
      ListRoutingControlsResponse,
      RoutingControl
    ](
      "listRoutingControls",
      api.listRoutingControls,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.routingControls().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.route53recoverycluster.model.RoutingControl.wrap(item)
      )
      .provideEnvironment(r)
    def listRoutingControlsPaginated(
        request: zio.aws.route53recoverycluster.model.ListRoutingControlsRequest
    ): IO[
      AwsError,
      zio.aws.route53recoverycluster.model.ListRoutingControlsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListRoutingControlsRequest,
      ListRoutingControlsResponse
    ]("listRoutingControls", api.listRoutingControls)(request.buildAwsValue())
      .map(
        zio.aws.route53recoverycluster.model.ListRoutingControlsResponse.wrap
      )
      .provideEnvironment(r)
    def updateRoutingControlState(
        request: zio.aws.route53recoverycluster.model.UpdateRoutingControlStateRequest
    ): IO[
      AwsError,
      zio.aws.route53recoverycluster.model.UpdateRoutingControlStateResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateRoutingControlStateRequest,
      UpdateRoutingControlStateResponse
    ]("updateRoutingControlState", api.updateRoutingControlState)(
      request.buildAwsValue()
    ).map(
      zio.aws.route53recoverycluster.model.UpdateRoutingControlStateResponse.wrap
    ).provideEnvironment(r)
    def updateRoutingControlStates(
        request: zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesRequest
    ): IO[
      AwsError,
      zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateRoutingControlStatesRequest,
      UpdateRoutingControlStatesResponse
    ]("updateRoutingControlStates", api.updateRoutingControlStates)(
      request.buildAwsValue()
    ).map(
      zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesResponse.wrap
    ).provideEnvironment(r)
  }
  def getRoutingControlState(
      request: zio.aws.route53recoverycluster.model.GetRoutingControlStateRequest
  ): ZIO[
    zio.aws.route53recoverycluster.Route53RecoveryCluster,
    AwsError,
    zio.aws.route53recoverycluster.model.GetRoutingControlStateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRoutingControlState(request))
  def listRoutingControls(
      request: zio.aws.route53recoverycluster.model.ListRoutingControlsRequest
  ): ZStream[
    zio.aws.route53recoverycluster.Route53RecoveryCluster,
    AwsError,
    ReadOnly
  ] = ZStream.serviceWithStream(_.listRoutingControls(request))
  def listRoutingControlsPaginated(
      request: zio.aws.route53recoverycluster.model.ListRoutingControlsRequest
  ): ZIO[
    zio.aws.route53recoverycluster.Route53RecoveryCluster,
    AwsError,
    zio.aws.route53recoverycluster.model.ListRoutingControlsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRoutingControlsPaginated(request))
  def updateRoutingControlState(
      request: zio.aws.route53recoverycluster.model.UpdateRoutingControlStateRequest
  ): ZIO[
    zio.aws.route53recoverycluster.Route53RecoveryCluster,
    AwsError,
    zio.aws.route53recoverycluster.model.UpdateRoutingControlStateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRoutingControlState(request))
  def updateRoutingControlStates(
      request: zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesRequest
  ): ZIO[
    zio.aws.route53recoverycluster.Route53RecoveryCluster,
    AwsError,
    zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRoutingControlStates(request))
}
