package zio.aws.route53recoverycluster.model
import scala.jdk.CollectionConverters._
sealed trait RoutingControlState {
  def unwrap: software.amazon.awssdk.services.route53recoverycluster.model.RoutingControlState
}
object RoutingControlState {
  def wrap(
      value: software.amazon.awssdk.services.route53recoverycluster.model.RoutingControlState
  ): zio.aws.route53recoverycluster.model.RoutingControlState = value match {
    case software.amazon.awssdk.services.route53recoverycluster.model.RoutingControlState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53recoverycluster.model.RoutingControlState.ON =>
      val r = On
      r
    case software.amazon.awssdk.services.route53recoverycluster.model.RoutingControlState.OFF =>
      val r = Off
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.route53recoverycluster.model.RoutingControlState {
    override def unwrap
        : software.amazon.awssdk.services.route53recoverycluster.model.RoutingControlState =
      software.amazon.awssdk.services.route53recoverycluster.model.RoutingControlState.UNKNOWN_TO_SDK_VERSION
  }
  case object On
      extends zio.aws.route53recoverycluster.model.RoutingControlState {
    override def unwrap
        : software.amazon.awssdk.services.route53recoverycluster.model.RoutingControlState =
      software.amazon.awssdk.services.route53recoverycluster.model.RoutingControlState.ON
  }
  case object Off
      extends zio.aws.route53recoverycluster.model.RoutingControlState {
    override def unwrap
        : software.amazon.awssdk.services.route53recoverycluster.model.RoutingControlState =
      software.amazon.awssdk.services.route53recoverycluster.model.RoutingControlState.OFF
  }
}
