package zio.aws.route53recoverycluster.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53recoverycluster.model.primitives.{RoutingControlName, Arn}
import scala.jdk.CollectionConverters._
final case class GetRoutingControlStateResponse(
    routingControlArn: Arn,
    routingControlState: zio.aws.route53recoverycluster.model.RoutingControlState,
    routingControlName: Optional[RoutingControlName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycluster.model.GetRoutingControlStateResponse = {
    import GetRoutingControlStateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycluster.model.GetRoutingControlStateResponse
      .builder()
      .routingControlArn(Arn.unwrap(routingControlArn): java.lang.String)
      .routingControlState(routingControlState.unwrap)
      .optionallyWith(
        routingControlName.map(value =>
          RoutingControlName.unwrap(value): java.lang.String
        )
      )(_.routingControlName)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycluster.model.GetRoutingControlStateResponse.ReadOnly =
    zio.aws.route53recoverycluster.model.GetRoutingControlStateResponse
      .wrap(buildAwsValue())
}
object GetRoutingControlStateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycluster.model.GetRoutingControlStateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycluster.model.GetRoutingControlStateResponse =
      zio.aws.route53recoverycluster.model.GetRoutingControlStateResponse(
        routingControlArn,
        routingControlState,
        routingControlName.map(value => value)
      )
    def routingControlArn: Arn
    def routingControlState
        : zio.aws.route53recoverycluster.model.RoutingControlState
    def routingControlName: Optional[RoutingControlName]
    def getRoutingControlArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(routingControlArn)
    def getRoutingControlState: ZIO[
      Any,
      Nothing,
      zio.aws.route53recoverycluster.model.RoutingControlState
    ] = ZIO.succeed(routingControlState)
    def getRoutingControlName: ZIO[Any, AwsError, RoutingControlName] =
      AwsError.unwrapOptionField("routingControlName", routingControlName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycluster.model.GetRoutingControlStateResponse
  ) extends zio.aws.route53recoverycluster.model.GetRoutingControlStateResponse.ReadOnly {
    override val routingControlArn: Arn =
      zio.aws.route53recoverycluster.model.primitives
        .Arn(impl.routingControlArn())
    override val routingControlState
        : zio.aws.route53recoverycluster.model.RoutingControlState =
      zio.aws.route53recoverycluster.model.RoutingControlState
        .wrap(impl.routingControlState())
    override val routingControlName: Optional[RoutingControlName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routingControlName())
        .map(value =>
          zio.aws.route53recoverycluster.model.primitives
            .RoutingControlName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycluster.model.GetRoutingControlStateResponse
  ): zio.aws.route53recoverycluster.model.GetRoutingControlStateResponse.ReadOnly =
    new Wrapper(impl)
}
