package zio.aws.route53recoverycluster.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53recoverycluster.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class ListRoutingControlsResponse(
    routingControls: Iterable[
      zio.aws.route53recoverycluster.model.RoutingControl
    ],
    nextToken: Optional[PageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycluster.model.ListRoutingControlsResponse = {
    import ListRoutingControlsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycluster.model.ListRoutingControlsResponse
      .builder()
      .routingControls(routingControls.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycluster.model.ListRoutingControlsResponse.ReadOnly =
    zio.aws.route53recoverycluster.model.ListRoutingControlsResponse
      .wrap(buildAwsValue())
}
object ListRoutingControlsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycluster.model.ListRoutingControlsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycluster.model.ListRoutingControlsResponse =
      zio.aws.route53recoverycluster.model.ListRoutingControlsResponse(
        routingControls.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def routingControls
        : List[zio.aws.route53recoverycluster.model.RoutingControl.ReadOnly]
    def nextToken: Optional[PageToken]
    def getRoutingControls: ZIO[Any, Nothing, List[
      zio.aws.route53recoverycluster.model.RoutingControl.ReadOnly
    ]] = ZIO.succeed(routingControls)
    def getNextToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycluster.model.ListRoutingControlsResponse
  ) extends zio.aws.route53recoverycluster.model.ListRoutingControlsResponse.ReadOnly {
    override val routingControls
        : List[zio.aws.route53recoverycluster.model.RoutingControl.ReadOnly] =
      impl
        .routingControls()
        .asScala
        .map { item =>
          zio.aws.route53recoverycluster.model.RoutingControl.wrap(item)
        }
        .toList
    override val nextToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.route53recoverycluster.model.primitives.PageToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycluster.model.ListRoutingControlsResponse
  ): zio.aws.route53recoverycluster.model.ListRoutingControlsResponse.ReadOnly =
    new Wrapper(impl)
}
