package zio.aws.route53recoverycluster
import zio.aws.route53recoverycluster.model.RoutingControl.ReadOnly
import software.amazon.awssdk.services.route53recoverycluster.Route53RecoveryClusterAsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.route53recoverycluster.model.{
  UpdateRoutingControlStatesRequest,
  UpdateRoutingControlStateRequest,
  ListRoutingControlsRequest,
  GetRoutingControlStateRequest
}
import zio.stream.ZStream
object Route53RecoveryClusterMock extends Mock[Route53RecoveryCluster] {
  object GetRoutingControlState
      extends Effect[
        GetRoutingControlStateRequest,
        AwsError,
        zio.aws.route53recoverycluster.model.GetRoutingControlStateResponse.ReadOnly
      ]
  object ListRoutingControls
      extends Stream[ListRoutingControlsRequest, AwsError, ReadOnly]
  object ListRoutingControlsPaginated
      extends Effect[
        ListRoutingControlsRequest,
        AwsError,
        zio.aws.route53recoverycluster.model.ListRoutingControlsResponse.ReadOnly
      ]
  object UpdateRoutingControlState
      extends Effect[
        UpdateRoutingControlStateRequest,
        AwsError,
        zio.aws.route53recoverycluster.model.UpdateRoutingControlStateResponse.ReadOnly
      ]
  object UpdateRoutingControlStates
      extends Effect[
        UpdateRoutingControlStatesRequest,
        AwsError,
        zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Route53RecoveryCluster] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Route53RecoveryCluster] { rts =>
        zio.ZIO.succeed {
          new Route53RecoveryCluster {
            val api: Route53RecoveryClusterAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Route53RecoveryCluster = this
            def getRoutingControlState(
                request: GetRoutingControlStateRequest
            ): IO[
              AwsError,
              zio.aws.route53recoverycluster.model.GetRoutingControlStateResponse.ReadOnly
            ] = proxy(GetRoutingControlState, request)
            def listRoutingControls(
                request: ListRoutingControlsRequest
            ): ZStream[Any, AwsError, ReadOnly] =
              rts.unsafeRun(proxy(ListRoutingControls, request))
            def listRoutingControlsPaginated(
                request: ListRoutingControlsRequest
            ): IO[
              AwsError,
              zio.aws.route53recoverycluster.model.ListRoutingControlsResponse.ReadOnly
            ] = proxy(ListRoutingControlsPaginated, request)
            def updateRoutingControlState(
                request: UpdateRoutingControlStateRequest
            ): IO[
              AwsError,
              zio.aws.route53recoverycluster.model.UpdateRoutingControlStateResponse.ReadOnly
            ] = proxy(UpdateRoutingControlState, request)
            def updateRoutingControlStates(
                request: UpdateRoutingControlStatesRequest
            ): IO[
              AwsError,
              zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesResponse.ReadOnly
            ] = proxy(UpdateRoutingControlStates, request)
          }
        }
      }
    }
  }
}
