package zio.aws.route53recoverycluster.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53recoverycluster.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class UpdateRoutingControlStateRequest(
    routingControlArn: Arn,
    routingControlState: zio.aws.route53recoverycluster.model.RoutingControlState,
    safetyRulesToOverride: Option[Iterable[Arn]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycluster.model.UpdateRoutingControlStateRequest = {
    import UpdateRoutingControlStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycluster.model.UpdateRoutingControlStateRequest
      .builder()
      .routingControlArn(Arn.unwrap(routingControlArn): java.lang.String)
      .routingControlState(routingControlState.unwrap)
      .optionallyWith(
        safetyRulesToOverride.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.safetyRulesToOverride)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycluster.model.UpdateRoutingControlStateRequest.ReadOnly =
    zio.aws.route53recoverycluster.model.UpdateRoutingControlStateRequest
      .wrap(buildAwsValue())
}
object UpdateRoutingControlStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycluster.model.UpdateRoutingControlStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycluster.model.UpdateRoutingControlStateRequest =
      zio.aws.route53recoverycluster.model.UpdateRoutingControlStateRequest(
        routingControlArn,
        routingControlState,
        safetyRulesToOverride.map(value => value)
      )
    def routingControlArn: Arn
    def routingControlState
        : zio.aws.route53recoverycluster.model.RoutingControlState
    def safetyRulesToOverride: Option[List[Arn]]
    def getRoutingControlArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(routingControlArn)
    def getRoutingControlState: ZIO[
      Any,
      Nothing,
      zio.aws.route53recoverycluster.model.RoutingControlState
    ] = ZIO.succeed(routingControlState)
    def getSafetyRulesToOverride: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("safetyRulesToOverride", safetyRulesToOverride)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycluster.model.UpdateRoutingControlStateRequest
  ) extends zio.aws.route53recoverycluster.model.UpdateRoutingControlStateRequest.ReadOnly {
    override val routingControlArn: Arn =
      zio.aws.route53recoverycluster.model.primitives
        .Arn(impl.routingControlArn())
    override val routingControlState
        : zio.aws.route53recoverycluster.model.RoutingControlState =
      zio.aws.route53recoverycluster.model.RoutingControlState
        .wrap(impl.routingControlState())
    override val safetyRulesToOverride: Option[List[Arn]] = scala
      .Option(impl.safetyRulesToOverride())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53recoverycluster.model.primitives.Arn(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycluster.model.UpdateRoutingControlStateRequest
  ): zio.aws.route53recoverycluster.model.UpdateRoutingControlStateRequest.ReadOnly =
    new Wrapper(impl)
}
