package zio.aws.route53recoverycluster.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53recoverycluster.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class UpdateRoutingControlStatesRequest(
    updateRoutingControlStateEntries: Iterable[
      zio.aws.route53recoverycluster.model.UpdateRoutingControlStateEntry
    ],
    safetyRulesToOverride: Option[Iterable[Arn]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycluster.model.UpdateRoutingControlStatesRequest = {
    import UpdateRoutingControlStatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycluster.model.UpdateRoutingControlStatesRequest
      .builder()
      .updateRoutingControlStateEntries(updateRoutingControlStateEntries.map {
        item =>
          item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        safetyRulesToOverride.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.safetyRulesToOverride)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesRequest.ReadOnly =
    zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesRequest
      .wrap(buildAwsValue())
}
object UpdateRoutingControlStatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycluster.model.UpdateRoutingControlStatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesRequest =
      zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesRequest(
        updateRoutingControlStateEntries.map { item =>
          item.asEditable
        },
        safetyRulesToOverride.map(value => value)
      )
    def updateRoutingControlStateEntries: List[
      zio.aws.route53recoverycluster.model.UpdateRoutingControlStateEntry.ReadOnly
    ]
    def safetyRulesToOverride: Option[List[Arn]]
    def getUpdateRoutingControlStateEntries: ZIO[Any, Nothing, List[
      zio.aws.route53recoverycluster.model.UpdateRoutingControlStateEntry.ReadOnly
    ]] = ZIO.succeed(updateRoutingControlStateEntries)
    def getSafetyRulesToOverride: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("safetyRulesToOverride", safetyRulesToOverride)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycluster.model.UpdateRoutingControlStatesRequest
  ) extends zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesRequest.ReadOnly {
    override val updateRoutingControlStateEntries: List[
      zio.aws.route53recoverycluster.model.UpdateRoutingControlStateEntry.ReadOnly
    ] = impl
      .updateRoutingControlStateEntries()
      .asScala
      .map { item =>
        zio.aws.route53recoverycluster.model.UpdateRoutingControlStateEntry
          .wrap(item)
      }
      .toList
    override val safetyRulesToOverride: Option[List[Arn]] = scala
      .Option(impl.safetyRulesToOverride())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53recoverycluster.model.primitives.Arn(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycluster.model.UpdateRoutingControlStatesRequest
  ): zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesRequest.ReadOnly =
    new Wrapper(impl)
}
