package zio.aws.route53recoverycluster
import software.amazon.awssdk.services.route53recoverycluster.Route53RecoveryClusterAsyncClient
import zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.route53recoverycluster.model.{
  UpdateRoutingControlStatesRequest,
  UpdateRoutingControlStateRequest,
  GetRoutingControlStateRequest
}
object Route53RecoveryClusterMock extends Mock[Route53RecoveryCluster] {
  object GetRoutingControlState
      extends Effect[
        GetRoutingControlStateRequest,
        AwsError,
        zio.aws.route53recoverycluster.model.GetRoutingControlStateResponse.ReadOnly
      ]
  object UpdateRoutingControlState
      extends Effect[
        UpdateRoutingControlStateRequest,
        AwsError,
        zio.aws.route53recoverycluster.model.UpdateRoutingControlStateResponse.ReadOnly
      ]
  object UpdateRoutingControlStates
      extends Effect[UpdateRoutingControlStatesRequest, AwsError, ReadOnly]
  val compose: URLayer[Proxy, Route53RecoveryCluster] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Route53RecoveryCluster {
          val api: Route53RecoveryClusterAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Route53RecoveryCluster = this
          def getRoutingControlState(
              request: GetRoutingControlStateRequest
          ): IO[
            AwsError,
            zio.aws.route53recoverycluster.model.GetRoutingControlStateResponse.ReadOnly
          ] = proxy(GetRoutingControlState, request)
          def updateRoutingControlState(
              request: UpdateRoutingControlStateRequest
          ): IO[
            AwsError,
            zio.aws.route53recoverycluster.model.UpdateRoutingControlStateResponse.ReadOnly
          ] = proxy(UpdateRoutingControlState, request)
          def updateRoutingControlStates(
              request: UpdateRoutingControlStatesRequest
          ): IO[AwsError, ReadOnly] = proxy(UpdateRoutingControlStates, request)
        }
      }
    }
    .toLayer
}
