package zio.aws.route53recoverycluster.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53recoverycluster.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class GetRoutingControlStateRequest(routingControlArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycluster.model.GetRoutingControlStateRequest = {
    import GetRoutingControlStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycluster.model.GetRoutingControlStateRequest
      .builder()
      .routingControlArn(Arn.unwrap(routingControlArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycluster.model.GetRoutingControlStateRequest.ReadOnly =
    zio.aws.route53recoverycluster.model.GetRoutingControlStateRequest
      .wrap(buildAwsValue())
}
object GetRoutingControlStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycluster.model.GetRoutingControlStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycluster.model.GetRoutingControlStateRequest =
      zio.aws.route53recoverycluster.model
        .GetRoutingControlStateRequest(routingControlArn)
    def routingControlArn: Arn
    def getRoutingControlArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(routingControlArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycluster.model.GetRoutingControlStateRequest
  ) extends zio.aws.route53recoverycluster.model.GetRoutingControlStateRequest.ReadOnly {
    override val routingControlArn: Arn =
      zio.aws.route53recoverycluster.model.primitives
        .Arn(impl.routingControlArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycluster.model.GetRoutingControlStateRequest
  ): zio.aws.route53recoverycluster.model.GetRoutingControlStateRequest.ReadOnly =
    new Wrapper(impl)
}
