package zio.aws.route53recoverycluster.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53recoverycluster.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class UpdateRoutingControlStateRequest(
    routingControlArn: Arn,
    routingControlState: zio.aws.route53recoverycluster.model.RoutingControlState
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycluster.model.UpdateRoutingControlStateRequest = {
    import UpdateRoutingControlStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycluster.model.UpdateRoutingControlStateRequest
      .builder()
      .routingControlArn(Arn.unwrap(routingControlArn): java.lang.String)
      .routingControlState(routingControlState.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycluster.model.UpdateRoutingControlStateRequest.ReadOnly =
    zio.aws.route53recoverycluster.model.UpdateRoutingControlStateRequest
      .wrap(buildAwsValue())
}
object UpdateRoutingControlStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycluster.model.UpdateRoutingControlStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycluster.model.UpdateRoutingControlStateRequest =
      zio.aws.route53recoverycluster.model.UpdateRoutingControlStateRequest(
        routingControlArn,
        routingControlState
      )
    def routingControlArn: Arn
    def routingControlState
        : zio.aws.route53recoverycluster.model.RoutingControlState
    def getRoutingControlArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(routingControlArn)
    def getRoutingControlState: ZIO[
      Any,
      Nothing,
      zio.aws.route53recoverycluster.model.RoutingControlState
    ] = ZIO.succeed(routingControlState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycluster.model.UpdateRoutingControlStateRequest
  ) extends zio.aws.route53recoverycluster.model.UpdateRoutingControlStateRequest.ReadOnly {
    override val routingControlArn: Arn =
      zio.aws.route53recoverycluster.model.primitives
        .Arn(impl.routingControlArn())
    override val routingControlState
        : zio.aws.route53recoverycluster.model.RoutingControlState =
      zio.aws.route53recoverycluster.model.RoutingControlState
        .wrap(impl.routingControlState())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycluster.model.UpdateRoutingControlStateRequest
  ): zio.aws.route53recoverycluster.model.UpdateRoutingControlStateRequest.ReadOnly =
    new Wrapper(impl)
}
