package zio.aws.route53recoverycluster
import software.amazon.awssdk.services.route53recoverycluster.{
  Route53RecoveryClusterAsyncClientBuilder,
  Route53RecoveryClusterAsyncClient
}
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.route53recoverycluster.model.{
  GetRoutingControlStateRequest,
  GetRoutingControlStateResponse,
  UpdateRoutingControlStateResponse,
  UpdateRoutingControlStateRequest,
  UpdateRoutingControlStatesResponse,
  UpdateRoutingControlStatesRequest
}
import zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesResponse.ReadOnly
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import scala.jdk.CollectionConverters._
trait Route53RecoveryCluster extends AspectSupport[Route53RecoveryCluster] {
  val api: Route53RecoveryClusterAsyncClient
  def getRoutingControlState(
      request: zio.aws.route53recoverycluster.model.GetRoutingControlStateRequest
  ): IO[
    AwsError,
    zio.aws.route53recoverycluster.model.GetRoutingControlStateResponse.ReadOnly
  ]
  def updateRoutingControlState(
      request: zio.aws.route53recoverycluster.model.UpdateRoutingControlStateRequest
  ): IO[
    AwsError,
    zio.aws.route53recoverycluster.model.UpdateRoutingControlStateResponse.ReadOnly
  ]
  def updateRoutingControlStates(
      request: zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesRequest
  ): IO[AwsError, ReadOnly]
}
object Route53RecoveryCluster {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Route53RecoveryCluster] =
    customized(identity)
  def customized(
      customization: Route53RecoveryClusterAsyncClientBuilder => Route53RecoveryClusterAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Route53RecoveryCluster] = managed(
    customization
  ).toLayer
  def managed(
      customization: Route53RecoveryClusterAsyncClientBuilder => Route53RecoveryClusterAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Route53RecoveryCluster] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = Route53RecoveryClusterAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[
        Route53RecoveryClusterAsyncClient,
        Route53RecoveryClusterAsyncClientBuilder
      ](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        Route53RecoveryClusterAsyncClient,
        Route53RecoveryClusterAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new Route53RecoveryClusterImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class Route53RecoveryClusterImpl[R](
      override val api: Route53RecoveryClusterAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Route53RecoveryCluster
      with AwsServiceBase[R] {
    override val serviceName: String = "Route53RecoveryCluster"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): Route53RecoveryClusterImpl[R1] =
      new Route53RecoveryClusterImpl(api, newAspect, r)
    def getRoutingControlState(
        request: zio.aws.route53recoverycluster.model.GetRoutingControlStateRequest
    ): IO[
      AwsError,
      zio.aws.route53recoverycluster.model.GetRoutingControlStateResponse.ReadOnly
    ] = asyncRequestResponse[
      GetRoutingControlStateRequest,
      GetRoutingControlStateResponse
    ]("getRoutingControlState", api.getRoutingControlState)(
      request.buildAwsValue()
    ).map(
      zio.aws.route53recoverycluster.model.GetRoutingControlStateResponse.wrap
    ).provideEnvironment(r)
    def updateRoutingControlState(
        request: zio.aws.route53recoverycluster.model.UpdateRoutingControlStateRequest
    ): IO[
      AwsError,
      zio.aws.route53recoverycluster.model.UpdateRoutingControlStateResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateRoutingControlStateRequest,
      UpdateRoutingControlStateResponse
    ]("updateRoutingControlState", api.updateRoutingControlState)(
      request.buildAwsValue()
    ).map(
      zio.aws.route53recoverycluster.model.UpdateRoutingControlStateResponse.wrap
    ).provideEnvironment(r)
    def updateRoutingControlStates(
        request: zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      UpdateRoutingControlStatesRequest,
      UpdateRoutingControlStatesResponse
    ]("updateRoutingControlStates", api.updateRoutingControlStates)(
      request.buildAwsValue()
    ).map(
      zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesResponse.wrap
    ).provideEnvironment(r)
  }
  def getRoutingControlState(
      request: zio.aws.route53recoverycluster.model.GetRoutingControlStateRequest
  ): ZIO[
    zio.aws.route53recoverycluster.Route53RecoveryCluster,
    AwsError,
    zio.aws.route53recoverycluster.model.GetRoutingControlStateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRoutingControlState(request))
  def updateRoutingControlState(
      request: zio.aws.route53recoverycluster.model.UpdateRoutingControlStateRequest
  ): ZIO[
    zio.aws.route53recoverycluster.Route53RecoveryCluster,
    AwsError,
    zio.aws.route53recoverycluster.model.UpdateRoutingControlStateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRoutingControlState(request))
  def updateRoutingControlStates(
      request: zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesRequest
  ): ZIO[
    zio.aws.route53recoverycluster.Route53RecoveryCluster,
    AwsError,
    ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRoutingControlStates(request))
}
