package zio.aws.route53recoverycluster.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateRoutingControlStatesRequest(
    updateRoutingControlStateEntries: Iterable[
      zio.aws.route53recoverycluster.model.UpdateRoutingControlStateEntry
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycluster.model.UpdateRoutingControlStatesRequest = {
    import UpdateRoutingControlStatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycluster.model.UpdateRoutingControlStatesRequest
      .builder()
      .updateRoutingControlStateEntries(updateRoutingControlStateEntries.map {
        item =>
          item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesRequest.ReadOnly =
    zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesRequest
      .wrap(buildAwsValue())
}
object UpdateRoutingControlStatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycluster.model.UpdateRoutingControlStatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesRequest =
      zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesRequest(
        updateRoutingControlStateEntries.map { item =>
          item.asEditable
        }
      )
    def updateRoutingControlStateEntries: List[
      zio.aws.route53recoverycluster.model.UpdateRoutingControlStateEntry.ReadOnly
    ]
    def getUpdateRoutingControlStateEntries: ZIO[Any, Nothing, List[
      zio.aws.route53recoverycluster.model.UpdateRoutingControlStateEntry.ReadOnly
    ]] = ZIO.succeed(updateRoutingControlStateEntries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycluster.model.UpdateRoutingControlStatesRequest
  ) extends zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesRequest.ReadOnly {
    override val updateRoutingControlStateEntries: List[
      zio.aws.route53recoverycluster.model.UpdateRoutingControlStateEntry.ReadOnly
    ] = impl
      .updateRoutingControlStateEntries()
      .asScala
      .map { item =>
        zio.aws.route53recoverycluster.model.UpdateRoutingControlStateEntry
          .wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycluster.model.UpdateRoutingControlStatesRequest
  ): zio.aws.route53recoverycluster.model.UpdateRoutingControlStatesRequest.ReadOnly =
    new Wrapper(impl)
}
