package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class DescribeWorldRequest(world: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DescribeWorldRequest = {
    import DescribeWorldRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DescribeWorldRequest
      .builder()
      .world(Arn.unwrap(world): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.DescribeWorldRequest.ReadOnly =
    zio.aws.robomaker.model.DescribeWorldRequest.wrap(buildAwsValue())
}
object DescribeWorldRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DescribeWorldRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DescribeWorldRequest =
      zio.aws.robomaker.model.DescribeWorldRequest(world)
    def world: Arn
    def getWorld: ZIO[Any, Nothing, Arn] = ZIO.succeed(world)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeWorldRequest
  ) extends zio.aws.robomaker.model.DescribeWorldRequest.ReadOnly {
    override val world: Arn =
      zio.aws.robomaker.model.primitives.Arn(impl.world())
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeWorldRequest
  ): zio.aws.robomaker.model.DescribeWorldRequest.ReadOnly = new Wrapper(impl)
}
