package zio.aws.robomaker.model
import zio.aws.robomaker.model.primitives.{
  TagValue,
  RevisionId,
  Arn,
  Version,
  Name,
  LastUpdatedAt,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateRobotApplicationResponse(
    arn: Optional[Arn] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    version: Optional[Version] = Optional.Absent,
    sources: Optional[Iterable[zio.aws.robomaker.model.Source]] =
      Optional.Absent,
    robotSoftwareSuite: Optional[zio.aws.robomaker.model.RobotSoftwareSuite] =
      Optional.Absent,
    lastUpdatedAt: Optional[LastUpdatedAt] = Optional.Absent,
    revisionId: Optional[RevisionId] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    environment: Optional[zio.aws.robomaker.model.Environment] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationResponse = {
    import CreateRobotApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        version.map(value => Version.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .optionallyWith(robotSoftwareSuite.map(value => value.buildAwsValue()))(
        _.robotSoftwareSuite
      )
      .optionallyWith(
        lastUpdatedAt.map(value => LastUpdatedAt.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        revisionId.map(value => RevisionId.unwrap(value): java.lang.String)
      )(_.revisionId)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.CreateRobotApplicationResponse.ReadOnly =
    zio.aws.robomaker.model.CreateRobotApplicationResponse.wrap(buildAwsValue())
}
object CreateRobotApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.CreateRobotApplicationResponse =
      zio.aws.robomaker.model.CreateRobotApplicationResponse(
        arn.map(value => value),
        name.map(value => value),
        version.map(value => value),
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        robotSoftwareSuite.map(value => value.asEditable),
        lastUpdatedAt.map(value => value),
        revisionId.map(value => value),
        tags.map(value => value),
        environment.map(value => value.asEditable)
      )
    def arn: Optional[Arn]
    def name: Optional[Name]
    def version: Optional[Version]
    def sources: Optional[List[zio.aws.robomaker.model.Source.ReadOnly]]
    def robotSoftwareSuite
        : Optional[zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly]
    def lastUpdatedAt: Optional[LastUpdatedAt]
    def revisionId: Optional[RevisionId]
    def tags: Optional[Map[TagKey, TagValue]]
    def environment: Optional[zio.aws.robomaker.model.Environment.ReadOnly]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("version", version)
    def getSources
        : ZIO[Any, AwsError, List[zio.aws.robomaker.model.Source.ReadOnly]] =
      AwsError.unwrapOptionField("sources", sources)
    def getRobotSoftwareSuite: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly
    ] = AwsError.unwrapOptionField("robotSoftwareSuite", robotSoftwareSuite)
    def getLastUpdatedAt: ZIO[Any, AwsError, LastUpdatedAt] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getRevisionId: ZIO[Any, AwsError, RevisionId] =
      AwsError.unwrapOptionField("revisionId", revisionId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getEnvironment
        : ZIO[Any, AwsError, zio.aws.robomaker.model.Environment.ReadOnly] =
      AwsError.unwrapOptionField("environment", environment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationResponse
  ) extends zio.aws.robomaker.model.CreateRobotApplicationResponse.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.robomaker.model.primitives.Name(value))
    override val version: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.robomaker.model.primitives.Version(value))
    override val sources
        : Optional[List[zio.aws.robomaker.model.Source.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.robomaker.model.Source.wrap(item)
          }.toList
        )
    override val robotSoftwareSuite
        : Optional[zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.robotSoftwareSuite())
        .map(value => zio.aws.robomaker.model.RobotSoftwareSuite.wrap(value))
    override val lastUpdatedAt: Optional[LastUpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.robomaker.model.primitives.LastUpdatedAt(value))
    override val revisionId: Optional[RevisionId] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionId())
      .map(value => zio.aws.robomaker.model.primitives.RevisionId(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val environment
        : Optional[zio.aws.robomaker.model.Environment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value => zio.aws.robomaker.model.Environment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationResponse
  ): zio.aws.robomaker.model.CreateRobotApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
