package zio.aws.robomaker.model
import zio.aws.robomaker.model.primitives.{
  Json,
  CreatedAt,
  TagValue,
  Arn,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeWorldResponse(
    arn: Optional[Arn] = Optional.Absent,
    generationJob: Optional[Arn] = Optional.Absent,
    template: Optional[Arn] = Optional.Absent,
    createdAt: Optional[CreatedAt] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    worldDescriptionBody: Optional[Json] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DescribeWorldResponse = {
    import DescribeWorldResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DescribeWorldResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        generationJob.map(value => Arn.unwrap(value): java.lang.String)
      )(_.generationJob)
      .optionallyWith(
        template.map(value => Arn.unwrap(value): java.lang.String)
      )(_.template)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        worldDescriptionBody.map(value => Json.unwrap(value): java.lang.String)
      )(_.worldDescriptionBody)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.DescribeWorldResponse.ReadOnly =
    zio.aws.robomaker.model.DescribeWorldResponse.wrap(buildAwsValue())
}
object DescribeWorldResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DescribeWorldResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DescribeWorldResponse =
      zio.aws.robomaker.model.DescribeWorldResponse(
        arn.map(value => value),
        generationJob.map(value => value),
        template.map(value => value),
        createdAt.map(value => value),
        tags.map(value => value),
        worldDescriptionBody.map(value => value)
      )
    def arn: Optional[Arn]
    def generationJob: Optional[Arn]
    def template: Optional[Arn]
    def createdAt: Optional[CreatedAt]
    def tags: Optional[Map[TagKey, TagValue]]
    def worldDescriptionBody: Optional[Json]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getGenerationJob: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("generationJob", generationJob)
    def getTemplate: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("template", template)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWorldDescriptionBody: ZIO[Any, AwsError, Json] =
      AwsError.unwrapOptionField("worldDescriptionBody", worldDescriptionBody)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeWorldResponse
  ) extends zio.aws.robomaker.model.DescribeWorldResponse.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val generationJob: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.generationJob())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val template: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.template())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val worldDescriptionBody: Optional[Json] = zio.aws.core.internal
      .optionalFromNullable(impl.worldDescriptionBody())
      .map(value => zio.aws.robomaker.model.primitives.Json(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeWorldResponse
  ): zio.aws.robomaker.model.DescribeWorldResponse.ReadOnly = new Wrapper(impl)
}
