package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListWorldsResponse(
    worldSummaries: Optional[Iterable[zio.aws.robomaker.model.WorldSummary]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.ListWorldsResponse = {
    import ListWorldsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.ListWorldsResponse
      .builder()
      .optionallyWith(
        worldSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.worldSummaries)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.ListWorldsResponse.ReadOnly =
    zio.aws.robomaker.model.ListWorldsResponse.wrap(buildAwsValue())
}
object ListWorldsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.ListWorldsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.ListWorldsResponse =
      zio.aws.robomaker.model.ListWorldsResponse(
        worldSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def worldSummaries
        : Optional[List[zio.aws.robomaker.model.WorldSummary.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getWorldSummaries: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.WorldSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("worldSummaries", worldSummaries)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.ListWorldsResponse
  ) extends zio.aws.robomaker.model.ListWorldsResponse.ReadOnly {
    override val worldSummaries
        : Optional[List[zio.aws.robomaker.model.WorldSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.worldSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.robomaker.model.WorldSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.robomaker.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.ListWorldsResponse
  ): zio.aws.robomaker.model.ListWorldsResponse.ReadOnly = new Wrapper(impl)
}
