package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class CancelSimulationJobRequest(job: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.CancelSimulationJobRequest = {
    import CancelSimulationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.CancelSimulationJobRequest
      .builder()
      .job(Arn.unwrap(job): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.CancelSimulationJobRequest.ReadOnly =
    zio.aws.robomaker.model.CancelSimulationJobRequest.wrap(buildAwsValue())
}
object CancelSimulationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.CancelSimulationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.CancelSimulationJobRequest =
      zio.aws.robomaker.model.CancelSimulationJobRequest(job)
    def job: Arn
    def getJob: ZIO[Any, Nothing, Arn] = ZIO.succeed(job)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.CancelSimulationJobRequest
  ) extends zio.aws.robomaker.model.CancelSimulationJobRequest.ReadOnly {
    override val job: Arn = zio.aws.robomaker.model.primitives.Arn(impl.job())
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.CancelSimulationJobRequest
  ): zio.aws.robomaker.model.CancelSimulationJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
