package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.BoxedBoolean
import scala.jdk.CollectionConverters._
final case class LoggingConfig(
    recordAllRosTopics: Optional[BoxedBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.LoggingConfig = {
    import LoggingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.LoggingConfig
      .builder()
      .optionallyWith(
        recordAllRosTopics.map(value => value: java.lang.Boolean)
      )(_.recordAllRosTopics)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.LoggingConfig.ReadOnly =
    zio.aws.robomaker.model.LoggingConfig.wrap(buildAwsValue())
}
object LoggingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.LoggingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.LoggingConfig =
      zio.aws.robomaker.model
        .LoggingConfig(recordAllRosTopics.map(value => value))
    def recordAllRosTopics: Optional[BoxedBoolean]
    def getRecordAllRosTopics: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("recordAllRosTopics", recordAllRosTopics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.LoggingConfig
  ) extends zio.aws.robomaker.model.LoggingConfig.ReadOnly {
    override val recordAllRosTopics: Optional[BoxedBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recordAllRosTopics())
        .map(value => value: BoxedBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.LoggingConfig
  ): zio.aws.robomaker.model.LoggingConfig.ReadOnly = new Wrapper(impl)
}
