package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PortForwardingConfig(
    portMappings: Optional[Iterable[zio.aws.robomaker.model.PortMapping]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.PortForwardingConfig = {
    import PortForwardingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.PortForwardingConfig
      .builder()
      .optionallyWith(
        portMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.portMappings)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.PortForwardingConfig.ReadOnly =
    zio.aws.robomaker.model.PortForwardingConfig.wrap(buildAwsValue())
}
object PortForwardingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.PortForwardingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.PortForwardingConfig =
      zio.aws.robomaker.model.PortForwardingConfig(
        portMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def portMappings
        : Optional[List[zio.aws.robomaker.model.PortMapping.ReadOnly]]
    def getPortMappings: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.PortMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("portMappings", portMappings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.PortForwardingConfig
  ) extends zio.aws.robomaker.model.PortForwardingConfig.ReadOnly {
    override val portMappings
        : Optional[List[zio.aws.robomaker.model.PortMapping.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portMappings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.robomaker.model.PortMapping.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.PortForwardingConfig
  ): zio.aws.robomaker.model.PortForwardingConfig.ReadOnly = new Wrapper(impl)
}
