package zio.aws.robomaker.model
import zio.aws.robomaker.model.primitives.{FailedAt, GenericString}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class FailedCreateSimulationJobRequest(
    request: Optional[zio.aws.robomaker.model.SimulationJobRequest] =
      Optional.Absent,
    failureReason: Optional[GenericString] = Optional.Absent,
    failureCode: Optional[zio.aws.robomaker.model.SimulationJobErrorCode] =
      Optional.Absent,
    failedAt: Optional[FailedAt] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.FailedCreateSimulationJobRequest = {
    import FailedCreateSimulationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.FailedCreateSimulationJobRequest
      .builder()
      .optionallyWith(request.map(value => value.buildAwsValue()))(_.request)
      .optionallyWith(failureReason.map(value => value: java.lang.String))(
        _.failureReason
      )
      .optionallyWith(failureCode.map(value => value.unwrap))(_.failureCode)
      .optionallyWith(failedAt.map(value => FailedAt.unwrap(value): Instant))(
        _.failedAt
      )
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.FailedCreateSimulationJobRequest.ReadOnly =
    zio.aws.robomaker.model.FailedCreateSimulationJobRequest
      .wrap(buildAwsValue())
}
object FailedCreateSimulationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.FailedCreateSimulationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.FailedCreateSimulationJobRequest =
      zio.aws.robomaker.model.FailedCreateSimulationJobRequest(
        request.map(value => value.asEditable),
        failureReason.map(value => value),
        failureCode.map(value => value),
        failedAt.map(value => value)
      )
    def request: Optional[zio.aws.robomaker.model.SimulationJobRequest.ReadOnly]
    def failureReason: Optional[GenericString]
    def failureCode: Optional[zio.aws.robomaker.model.SimulationJobErrorCode]
    def failedAt: Optional[FailedAt]
    def getRequest: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.SimulationJobRequest.ReadOnly
    ] = AwsError.unwrapOptionField("request", request)
    def getFailureReason: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getFailureCode
        : ZIO[Any, AwsError, zio.aws.robomaker.model.SimulationJobErrorCode] =
      AwsError.unwrapOptionField("failureCode", failureCode)
    def getFailedAt: ZIO[Any, AwsError, FailedAt] =
      AwsError.unwrapOptionField("failedAt", failedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.FailedCreateSimulationJobRequest
  ) extends zio.aws.robomaker.model.FailedCreateSimulationJobRequest.ReadOnly {
    override val request
        : Optional[zio.aws.robomaker.model.SimulationJobRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.request())
        .map(value => zio.aws.robomaker.model.SimulationJobRequest.wrap(value))
    override val failureReason: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => value: GenericString)
    override val failureCode
        : Optional[zio.aws.robomaker.model.SimulationJobErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureCode())
        .map(value =>
          zio.aws.robomaker.model.SimulationJobErrorCode.wrap(value)
        )
    override val failedAt: Optional[FailedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.failedAt())
      .map(value => zio.aws.robomaker.model.primitives.FailedAt(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.FailedCreateSimulationJobRequest
  ): zio.aws.robomaker.model.FailedCreateSimulationJobRequest.ReadOnly =
    new Wrapper(impl)
}
