package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListRobotApplicationsResponse(
    robotApplicationSummaries: Optional[
      Iterable[zio.aws.robomaker.model.RobotApplicationSummary]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse = {
    import ListRobotApplicationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse
      .builder()
      .optionallyWith(
        robotApplicationSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.robotApplicationSummaries)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.ListRobotApplicationsResponse.ReadOnly =
    zio.aws.robomaker.model.ListRobotApplicationsResponse.wrap(buildAwsValue())
}
object ListRobotApplicationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.ListRobotApplicationsResponse =
      zio.aws.robomaker.model.ListRobotApplicationsResponse(
        robotApplicationSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def robotApplicationSummaries: Optional[
      List[zio.aws.robomaker.model.RobotApplicationSummary.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getRobotApplicationSummaries: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.RobotApplicationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "robotApplicationSummaries",
      robotApplicationSummaries
    )
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse
  ) extends zio.aws.robomaker.model.ListRobotApplicationsResponse.ReadOnly {
    override val robotApplicationSummaries: Optional[
      List[zio.aws.robomaker.model.RobotApplicationSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.robotApplicationSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.RobotApplicationSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.robomaker.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse
  ): zio.aws.robomaker.model.ListRobotApplicationsResponse.ReadOnly =
    new Wrapper(impl)
}
