package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.{Path, S3Bucket, Name}
import scala.jdk.CollectionConverters._
final case class DataSource(
    name: Optional[Name] = Optional.Absent,
    s3Bucket: Optional[S3Bucket] = Optional.Absent,
    s3Keys: Optional[Iterable[zio.aws.robomaker.model.S3KeyOutput]] =
      Optional.Absent,
    `type`: Optional[zio.aws.robomaker.model.DataSourceType] = Optional.Absent,
    destination: Optional[Path] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DataSource = {
    import DataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DataSource
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        s3Bucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.s3Bucket)
      .optionallyWith(
        s3Keys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.s3Keys)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        destination.map(value => Path.unwrap(value): java.lang.String)
      )(_.destination)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.DataSource.ReadOnly =
    zio.aws.robomaker.model.DataSource.wrap(buildAwsValue())
}
object DataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DataSource =
      zio.aws.robomaker.model.DataSource(
        name.map(value => value),
        s3Bucket.map(value => value),
        s3Keys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        `type`.map(value => value),
        destination.map(value => value)
      )
    def name: Optional[Name]
    def s3Bucket: Optional[S3Bucket]
    def s3Keys: Optional[List[zio.aws.robomaker.model.S3KeyOutput.ReadOnly]]
    def `type`: Optional[zio.aws.robomaker.model.DataSourceType]
    def destination: Optional[Path]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getS3Bucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getS3Keys: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.S3KeyOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("s3Keys", s3Keys)
    def getType: ZIO[Any, AwsError, zio.aws.robomaker.model.DataSourceType] =
      AwsError.unwrapOptionField("type", `type`)
    def getDestination: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("destination", destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DataSource
  ) extends zio.aws.robomaker.model.DataSource.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.robomaker.model.primitives.Name(value))
    override val s3Bucket: Optional[S3Bucket] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Bucket())
      .map(value => zio.aws.robomaker.model.primitives.S3Bucket(value))
    override val s3Keys
        : Optional[List[zio.aws.robomaker.model.S3KeyOutput.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Keys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.robomaker.model.S3KeyOutput.wrap(item)
          }.toList
        )
    override val `type`: Optional[zio.aws.robomaker.model.DataSourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.robomaker.model.DataSourceType.wrap(value))
    override val destination: Optional[Path] = zio.aws.core.internal
      .optionalFromNullable(impl.destination())
      .map(value => zio.aws.robomaker.model.primitives.Path(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DataSource
  ): zio.aws.robomaker.model.DataSource.ReadOnly = new Wrapper(impl)
}
