package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.{
  IamRole,
  TagValue,
  JobDuration,
  BoxedBoolean,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class SimulationJobRequest(
    outputLocation: Optional[zio.aws.robomaker.model.OutputLocation] =
      Optional.Absent,
    loggingConfig: Optional[zio.aws.robomaker.model.LoggingConfig] =
      Optional.Absent,
    maxJobDurationInSeconds: JobDuration,
    iamRole: Optional[IamRole] = Optional.Absent,
    failureBehavior: Optional[zio.aws.robomaker.model.FailureBehavior] =
      Optional.Absent,
    useDefaultApplications: Optional[BoxedBoolean] = Optional.Absent,
    robotApplications: Optional[
      Iterable[zio.aws.robomaker.model.RobotApplicationConfig]
    ] = Optional.Absent,
    simulationApplications: Optional[
      Iterable[zio.aws.robomaker.model.SimulationApplicationConfig]
    ] = Optional.Absent,
    dataSources: Optional[Iterable[zio.aws.robomaker.model.DataSourceConfig]] =
      Optional.Absent,
    vpcConfig: Optional[zio.aws.robomaker.model.VPCConfig] = Optional.Absent,
    compute: Optional[zio.aws.robomaker.model.Compute] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.SimulationJobRequest = {
    import SimulationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.SimulationJobRequest
      .builder()
      .optionallyWith(outputLocation.map(value => value.buildAwsValue()))(
        _.outputLocation
      )
      .optionallyWith(loggingConfig.map(value => value.buildAwsValue()))(
        _.loggingConfig
      )
      .maxJobDurationInSeconds(
        JobDuration.unwrap(maxJobDurationInSeconds): java.lang.Long
      )
      .optionallyWith(
        iamRole.map(value => IamRole.unwrap(value): java.lang.String)
      )(_.iamRole)
      .optionallyWith(failureBehavior.map(value => value.unwrap))(
        _.failureBehavior
      )
      .optionallyWith(
        useDefaultApplications.map(value => value: java.lang.Boolean)
      )(_.useDefaultApplications)
      .optionallyWith(
        robotApplications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.robotApplications)
      .optionallyWith(
        simulationApplications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.simulationApplications)
      .optionallyWith(
        dataSources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataSources)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(compute.map(value => value.buildAwsValue()))(_.compute)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.SimulationJobRequest.ReadOnly =
    zio.aws.robomaker.model.SimulationJobRequest.wrap(buildAwsValue())
}
object SimulationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.SimulationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.SimulationJobRequest =
      zio.aws.robomaker.model.SimulationJobRequest(
        outputLocation.map(value => value.asEditable),
        loggingConfig.map(value => value.asEditable),
        maxJobDurationInSeconds,
        iamRole.map(value => value),
        failureBehavior.map(value => value),
        useDefaultApplications.map(value => value),
        robotApplications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        simulationApplications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataSources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcConfig.map(value => value.asEditable),
        compute.map(value => value.asEditable),
        tags.map(value => value)
      )
    def outputLocation
        : Optional[zio.aws.robomaker.model.OutputLocation.ReadOnly]
    def loggingConfig: Optional[zio.aws.robomaker.model.LoggingConfig.ReadOnly]
    def maxJobDurationInSeconds: JobDuration
    def iamRole: Optional[IamRole]
    def failureBehavior: Optional[zio.aws.robomaker.model.FailureBehavior]
    def useDefaultApplications: Optional[BoxedBoolean]
    def robotApplications: Optional[
      List[zio.aws.robomaker.model.RobotApplicationConfig.ReadOnly]
    ]
    def simulationApplications: Optional[
      List[zio.aws.robomaker.model.SimulationApplicationConfig.ReadOnly]
    ]
    def dataSources
        : Optional[List[zio.aws.robomaker.model.DataSourceConfig.ReadOnly]]
    def vpcConfig: Optional[zio.aws.robomaker.model.VPCConfig.ReadOnly]
    def compute: Optional[zio.aws.robomaker.model.Compute.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getOutputLocation
        : ZIO[Any, AwsError, zio.aws.robomaker.model.OutputLocation.ReadOnly] =
      AwsError.unwrapOptionField("outputLocation", outputLocation)
    def getLoggingConfig
        : ZIO[Any, AwsError, zio.aws.robomaker.model.LoggingConfig.ReadOnly] =
      AwsError.unwrapOptionField("loggingConfig", loggingConfig)
    def getMaxJobDurationInSeconds: ZIO[Any, Nothing, JobDuration] =
      ZIO.succeed(maxJobDurationInSeconds)
    def getIamRole: ZIO[Any, AwsError, IamRole] =
      AwsError.unwrapOptionField("iamRole", iamRole)
    def getFailureBehavior
        : ZIO[Any, AwsError, zio.aws.robomaker.model.FailureBehavior] =
      AwsError.unwrapOptionField("failureBehavior", failureBehavior)
    def getUseDefaultApplications: ZIO[Any, AwsError, BoxedBoolean] = AwsError
      .unwrapOptionField("useDefaultApplications", useDefaultApplications)
    def getRobotApplications: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.RobotApplicationConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("robotApplications", robotApplications)
    def getSimulationApplications: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.SimulationApplicationConfig.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "simulationApplications",
      simulationApplications
    )
    def getDataSources: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.DataSourceConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("dataSources", dataSources)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.robomaker.model.VPCConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getCompute
        : ZIO[Any, AwsError, zio.aws.robomaker.model.Compute.ReadOnly] =
      AwsError.unwrapOptionField("compute", compute)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.SimulationJobRequest
  ) extends zio.aws.robomaker.model.SimulationJobRequest.ReadOnly {
    override val outputLocation
        : Optional[zio.aws.robomaker.model.OutputLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputLocation())
        .map(value => zio.aws.robomaker.model.OutputLocation.wrap(value))
    override val loggingConfig
        : Optional[zio.aws.robomaker.model.LoggingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingConfig())
        .map(value => zio.aws.robomaker.model.LoggingConfig.wrap(value))
    override val maxJobDurationInSeconds: JobDuration =
      zio.aws.robomaker.model.primitives
        .JobDuration(impl.maxJobDurationInSeconds())
    override val iamRole: Optional[IamRole] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRole())
      .map(value => zio.aws.robomaker.model.primitives.IamRole(value))
    override val failureBehavior
        : Optional[zio.aws.robomaker.model.FailureBehavior] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureBehavior())
        .map(value => zio.aws.robomaker.model.FailureBehavior.wrap(value))
    override val useDefaultApplications: Optional[BoxedBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.useDefaultApplications())
        .map(value => value: BoxedBoolean)
    override val robotApplications: Optional[
      List[zio.aws.robomaker.model.RobotApplicationConfig.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.robotApplications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.RobotApplicationConfig.wrap(item)
        }.toList
      )
    override val simulationApplications: Optional[
      List[zio.aws.robomaker.model.SimulationApplicationConfig.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.simulationApplications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.SimulationApplicationConfig.wrap(item)
        }.toList
      )
    override val dataSources
        : Optional[List[zio.aws.robomaker.model.DataSourceConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.robomaker.model.DataSourceConfig.wrap(item)
          }.toList
        )
    override val vpcConfig
        : Optional[zio.aws.robomaker.model.VPCConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.robomaker.model.VPCConfig.wrap(value))
    override val compute: Optional[zio.aws.robomaker.model.Compute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compute())
        .map(value => zio.aws.robomaker.model.Compute.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.SimulationJobRequest
  ): zio.aws.robomaker.model.SimulationJobRequest.ReadOnly = new Wrapper(impl)
}
