package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class RestartSimulationJobRequest(job: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.RestartSimulationJobRequest = {
    import RestartSimulationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.RestartSimulationJobRequest
      .builder()
      .job(Arn.unwrap(job): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.RestartSimulationJobRequest.ReadOnly =
    zio.aws.robomaker.model.RestartSimulationJobRequest.wrap(buildAwsValue())
}
object RestartSimulationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.RestartSimulationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.RestartSimulationJobRequest =
      zio.aws.robomaker.model.RestartSimulationJobRequest(job)
    def job: Arn
    def getJob: ZIO[Any, Nothing, Arn] = ZIO.succeed(job)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.RestartSimulationJobRequest
  ) extends zio.aws.robomaker.model.RestartSimulationJobRequest.ReadOnly {
    override val job: Arn = zio.aws.robomaker.model.primitives.Arn(impl.job())
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.RestartSimulationJobRequest
  ): zio.aws.robomaker.model.RestartSimulationJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
