package zio.aws.robomaker.model
import scala.jdk.CollectionConverters._
sealed trait DataSourceType {
  def unwrap: software.amazon.awssdk.services.robomaker.model.DataSourceType
}
object DataSourceType {
  def wrap(
      value: software.amazon.awssdk.services.robomaker.model.DataSourceType
  ): zio.aws.robomaker.model.DataSourceType = value match {
    case software.amazon.awssdk.services.robomaker.model.DataSourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.robomaker.model.DataSourceType.PREFIX =>
      val r = Prefix
      r
    case software.amazon.awssdk.services.robomaker.model.DataSourceType.ARCHIVE =>
      val r = Archive
      r
    case software.amazon.awssdk.services.robomaker.model.DataSourceType.FILE =>
      val r = File
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.robomaker.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DataSourceType =
      software.amazon.awssdk.services.robomaker.model.DataSourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object Prefix extends zio.aws.robomaker.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DataSourceType =
      software.amazon.awssdk.services.robomaker.model.DataSourceType.PREFIX
  }
  case object Archive extends zio.aws.robomaker.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DataSourceType =
      software.amazon.awssdk.services.robomaker.model.DataSourceType.ARCHIVE
  }
  case object File extends zio.aws.robomaker.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DataSourceType =
      software.amazon.awssdk.services.robomaker.model.DataSourceType.FILE
  }
}
