package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class DescribeSimulationJobRequest(job: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobRequest = {
    import DescribeSimulationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobRequest
      .builder()
      .job(Arn.unwrap(job): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.DescribeSimulationJobRequest.ReadOnly =
    zio.aws.robomaker.model.DescribeSimulationJobRequest.wrap(buildAwsValue())
}
object DescribeSimulationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DescribeSimulationJobRequest =
      zio.aws.robomaker.model.DescribeSimulationJobRequest(job)
    def job: Arn
    def getJob: ZIO[Any, Nothing, Arn] = ZIO.succeed(job)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobRequest
  ) extends zio.aws.robomaker.model.DescribeSimulationJobRequest.ReadOnly {
    override val job: Arn = zio.aws.robomaker.model.primitives.Arn(impl.job())
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobRequest
  ): zio.aws.robomaker.model.DescribeSimulationJobRequest.ReadOnly =
    new Wrapper(impl)
}
