package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class GetWorldTemplateBodyRequest(
    template: Optional[Arn] = Optional.Absent,
    generationJob: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.GetWorldTemplateBodyRequest = {
    import GetWorldTemplateBodyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.GetWorldTemplateBodyRequest
      .builder()
      .optionallyWith(
        template.map(value => Arn.unwrap(value): java.lang.String)
      )(_.template)
      .optionallyWith(
        generationJob.map(value => Arn.unwrap(value): java.lang.String)
      )(_.generationJob)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.GetWorldTemplateBodyRequest.ReadOnly =
    zio.aws.robomaker.model.GetWorldTemplateBodyRequest.wrap(buildAwsValue())
}
object GetWorldTemplateBodyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.GetWorldTemplateBodyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.GetWorldTemplateBodyRequest =
      zio.aws.robomaker.model.GetWorldTemplateBodyRequest(
        template.map(value => value),
        generationJob.map(value => value)
      )
    def template: Optional[Arn]
    def generationJob: Optional[Arn]
    def getTemplate: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("template", template)
    def getGenerationJob: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("generationJob", generationJob)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.GetWorldTemplateBodyRequest
  ) extends zio.aws.robomaker.model.GetWorldTemplateBodyRequest.ReadOnly {
    override val template: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.template())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val generationJob: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.generationJob())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.GetWorldTemplateBodyRequest
  ): zio.aws.robomaker.model.GetWorldTemplateBodyRequest.ReadOnly = new Wrapper(
    impl
  )
}
